/*
 * Decompiled with CFR 0.152.
 */
package com.uber.jaeger;

import com.uber.jaeger.exceptions.EmptyTracerStateStringException;
import com.uber.jaeger.exceptions.MalformedTracerStateStringException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SpanContext
implements io.opentracing.SpanContext {
    protected static final byte flagSampled = 1;
    protected static final byte flagDebug = 2;
    private final long traceID;
    private final long spanID;
    private final long parentID;
    private final byte flags;
    private final Map<String, String> baggage;
    private final String debugID;

    public SpanContext(long traceID, long spanID, long parentID, byte flags) {
        this(traceID, spanID, parentID, flags, Collections.emptyMap(), null);
    }

    SpanContext(long traceID, long spanID, long parentID, byte flags, Map<String, String> baggage, String debugID) {
        if (baggage == null) {
            throw new NullPointerException();
        }
        this.traceID = traceID;
        this.spanID = spanID;
        this.parentID = parentID;
        this.flags = flags;
        this.baggage = baggage;
        this.debugID = debugID;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    public String getBaggageItem(String key) {
        return this.baggage.get(key);
    }

    Map<String, String> baggage() {
        return this.baggage;
    }

    public long getTraceID() {
        return this.traceID;
    }

    public long getSpanID() {
        return this.spanID;
    }

    public long getParentID() {
        return this.parentID;
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean isSampled() {
        return (this.flags & 1) == 1;
    }

    public boolean isDebug() {
        return (this.flags & 2) == 2;
    }

    public String contextAsString() {
        return String.format("%x:%x:%x:%x", this.traceID, this.spanID, this.parentID, this.flags);
    }

    public String toString() {
        return this.contextAsString();
    }

    public static SpanContext contextFromString(String value) throws MalformedTracerStateStringException, EmptyTracerStateStringException {
        if (value == null || value.equals("")) {
            throw new EmptyTracerStateStringException();
        }
        String[] parts = value.split(":");
        if (parts.length != 4) {
            throw new MalformedTracerStateStringException(value);
        }
        return new SpanContext(new BigInteger(parts[0], 16).longValue(), new BigInteger(parts[1], 16).longValue(), new BigInteger(parts[2], 16).longValue(), new BigInteger(parts[3], 16).byteValue());
    }

    public SpanContext withBaggageItem(String key, String val) {
        HashMap<String, String> newBaggage = new HashMap<String, String>(this.baggage);
        newBaggage.put(key, val);
        return new SpanContext(this.traceID, this.spanID, this.parentID, this.flags, newBaggage, this.debugID);
    }

    public SpanContext withBaggage(Map<String, String> newBaggage) {
        return new SpanContext(this.traceID, this.spanID, this.parentID, this.flags, newBaggage, this.debugID);
    }

    public SpanContext withFlags(byte flags) {
        return new SpanContext(this.traceID, this.spanID, this.parentID, flags, this.baggage, this.debugID);
    }

    boolean isDebugIDContainerOnly() {
        return this.traceID == 0L && this.debugID != null;
    }

    public static SpanContext withDebugID(String debugID) {
        return new SpanContext(0L, 0L, 0L, 0, Collections.<String, String>emptyMap(), debugID);
    }

    String getDebugID() {
        return this.debugID;
    }
}

