/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.netty3.http;

import com.twitter.finagle.http.codec.ChannelBufferUsageTracker;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001e3A!\u0001\u0002\u0005\u001b\t!2\t[1o]\u0016d')\u001e4gKJl\u0015M\\1hKJT!a\u0001\u0003\u0002\t!$H\u000f\u001d\u0006\u0003\u000b\u0019\taA\\3uif\u001c$BA\u0004\t\u0003\u001d1\u0017N\\1hY\u0016T!!\u0003\u0006\u0002\u000fQ<\u0018\u000e\u001e;fe*\t1\"A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002G\u0007\u0002!)\u0011\u0011CE\u0001\bG\"\fgN\\3m\u0015\t\u0019B#A\u0003oKR$\u0018P\u0003\u0002\u0016-\u0005)!NY8tg*\tq#A\u0002pe\u001eL!!\u0007\t\u0003)MKW\u000e\u001d7f\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0011!Y\u0002A!A!\u0002\u0013a\u0012\u0001D;tC\u001e,GK]1dW\u0016\u0014\bCA\u000f\"\u001b\u0005q\"BA\u0010!\u0003\u0015\u0019w\u000eZ3d\u0015\t\u0019a!\u0003\u0002#=\tI2\t[1o]\u0016d')\u001e4gKJ,6/Y4f)J\f7m[3s\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q\u0011a\u0005\u000b\t\u0003O\u0001i\u0011A\u0001\u0005\u00067\r\u0002\r\u0001\b\u0005\u0007U\u0001\u0001\u000b\u0015B\u0016\u0002\u0017\t,hMZ3s+N\fw-\u001a\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0005\u0019>tw\rC\u00033\u0001\u0011\u00053'A\bnKN\u001c\u0018mZ3SK\u000e,\u0017N^3e)\r!t\u0007\u0010\t\u0003YUJ!AN\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006qE\u0002\r!O\u0001\u0004GRD\bCA\b;\u0013\tY\u0004CA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\t\u000bu\n\u0004\u0019\u0001 \u0002\u0003\u0015\u0004\"aD \n\u0005\u0001\u0003\"\u0001D'fgN\fw-Z#wK:$\b\"\u0002\"\u0001\t\u0003\u001a\u0015!D<sSR,7i\\7qY\u0016$X\rF\u00025\t\u0016CQ\u0001O!A\u0002eBQ!P!A\u0002\u0019\u0003\"aD$\n\u0005!\u0003\"\u0001F,sSR,7i\\7qY\u0016$\u0018n\u001c8Fm\u0016tG\u000fC\u0003K\u0001\u0011\u00053*A\u0007dQ\u0006tg.\u001a7DY>\u001cX\r\u001a\u000b\u0004i1k\u0005\"\u0002\u001dJ\u0001\u0004I\u0004\"B\u001fJ\u0001\u0004q\u0005CA\bP\u0013\t\u0001\u0006CA\tDQ\u0006tg.\u001a7Ti\u0006$X-\u0012<f]RDaA\u0015\u0001!\n\u0013\u0019\u0016aE5oGJ,\u0017m]3Ck\u001a4WM]+tC\u001e,GC\u0001\u001bU\u0011\u0015)\u0016\u000b1\u0001,\u0003\u0011\u0019\u0018N_3\t\r]\u0003\u0001\u0015\"\u0003Y\u0003A\u0019G.Z1s\u0005V4g-\u001a:Vg\u0006<W\rF\u00015\u0001")
public class ChannelBufferManager
extends SimpleChannelHandler {
    private final ChannelBufferUsageTracker usageTracker;
    private long bufferUsage;

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Object object = e.getMessage();
        if (object instanceof ChannelBuffer) {
            ChannelBuffer channelBuffer = (ChannelBuffer)object;
            this.increaseBufferUsage(channelBuffer.capacity());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        super.messageReceived(ctx, e);
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) {
        this.clearBufferUsage();
        super.writeComplete(ctx, e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.clearBufferUsage();
        super.channelClosed(ctx, e);
    }

    private void increaseBufferUsage(long size) {
        this.usageTracker.increase(size);
        this.bufferUsage += size;
    }

    private void clearBufferUsage() {
        this.usageTracker.decrease(this.bufferUsage);
        this.bufferUsage = 0L;
    }

    public ChannelBufferManager(ChannelBufferUsageTracker usageTracker) {
        this.usageTracker = usageTracker;
        this.bufferUsage = 0L;
    }
}

