/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http.netty4;

import com.twitter.conversions.time$;
import com.twitter.finagle.http.Cookie;
import com.twitter.finagle.http.Cookie$;
import com.twitter.finagle.http.CookieCodec;
import com.twitter.util.Duration;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;

public final class Netty4CookieCodec$
extends CookieCodec {
    public static Netty4CookieCodec$ MODULE$;
    private final ClientCookieEncoder clientEncoder;
    private final ServerCookieEncoder serverEncoder;
    private final ClientCookieDecoder clientDecoder;
    private final ServerCookieDecoder serverDecoder;
    private final Function1<Cookie, io.netty.handler.codec.http.cookie.Cookie> cookieToNetty;
    private final Function1<io.netty.handler.codec.http.cookie.Cookie, Cookie> cookieToFinagle;

    static {
        new Netty4CookieCodec$();
    }

    @Override
    public String encodeClient(Iterable<Cookie> cookies) {
        return cookies.isEmpty() ? "" : this.clientEncoder.encode((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)cookies.map(this.cookieToNetty(), Iterable$.MODULE$.canBuildFrom())).asJava());
    }

    @Override
    public String encodeServer(Cookie cookie) {
        return this.serverEncoder.encode((io.netty.handler.codec.http.cookie.Cookie)this.cookieToNetty().apply((Object)cookie));
    }

    @Override
    public Option<Iterable<Cookie>> decodeClient(String header) {
        io.netty.handler.codec.http.cookie.Cookie cookie = this.clientDecoder.decode(header);
        return cookie != null ? new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cookie[]{(Cookie)this.cookieToFinagle().apply((Object)cookie)}))) : None$.MODULE$;
    }

    @Override
    public Option<Iterable<Cookie>> decodeServer(String header) {
        Set cookies = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.serverDecoder.decode(header)).asScala()).map(this.cookieToFinagle(), Set$.MODULE$.canBuildFrom());
        return !cookies.isEmpty() ? new Some((Object)cookies) : None$.MODULE$;
    }

    public Function1<Cookie, io.netty.handler.codec.http.cookie.Cookie> cookieToNetty() {
        return this.cookieToNetty;
    }

    public Function1<io.netty.handler.codec.http.cookie.Cookie, Cookie> cookieToFinagle() {
        return this.cookieToFinagle;
    }

    private Netty4CookieCodec$() {
        MODULE$ = this;
        this.clientEncoder = ClientCookieEncoder.STRICT;
        this.serverEncoder = ServerCookieEncoder.STRICT;
        this.clientDecoder = ClientCookieDecoder.STRICT;
        this.serverDecoder = ServerCookieDecoder.STRICT;
        this.cookieToNetty = (Function1 & Serializable & scala.Serializable)c -> {
            void var1_1;
            DefaultCookie nc = new DefaultCookie(c.name(), c.value());
            nc.setDomain(c.domain());
            nc.setPath(c.path());
            Duration duration = c.maxAge();
            Duration duration2 = Cookie$.MODULE$.DefaultMaxAge();
            if (duration == null ? duration2 != null : !duration.equals(duration2)) {
                nc.setMaxAge((long)c.maxAge().inSeconds());
            }
            nc.setSecure(c.secure());
            nc.setHttpOnly(c.httpOnly());
            return var1_1;
        };
        this.cookieToFinagle = (Function1 & Serializable & scala.Serializable)nc -> {
            void var1_8;
            String x$1 = nc.name();
            String x$2 = nc.value();
            Option x$3 = Option$.MODULE$.apply((Object)nc.domain());
            Option x$4 = Option$.MODULE$.apply((Object)nc.path());
            boolean x$5 = nc.isSecure();
            boolean x$6 = nc.isHttpOnly();
            Option<Duration> x$7 = Cookie$.MODULE$.$lessinit$greater$default$5();
            Cookie cookie = new Cookie(x$1, x$2, (Option<String>)x$3, (Option<String>)x$4, x$7, x$5, x$6);
            return nc.maxAge() != Long.MIN_VALUE ? cookie.maxAge((Option<Duration>)new Some((Object)time$.MODULE$.longToTimeableNumber(nc.maxAge()).seconds())) : var1_8;
        };
    }
}

