/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tngtech.jgiven.annotation.As;
import com.tngtech.jgiven.annotation.AsProvider;
import com.tngtech.jgiven.annotation.Description;
import com.tngtech.jgiven.impl.params.DefaultAsProvider;
import com.tngtech.jgiven.impl.util.AssertionUtil;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class ReportModel {
    private String className;
    private String name;
    private String description;
    private List<ScenarioModel> scenarios = Lists.newArrayList();
    private Map<String, Tag> tagMap = Maps.newLinkedHashMap();

    public void accept(ReportModelVisitor visitor) {
        visitor.visit(this);
        List<ScenarioModel> sorted = this.sortByDescription();
        for (ScenarioModel m : sorted) {
            m.accept(visitor);
        }
        visitor.visitEnd(this);
    }

    private List<ScenarioModel> sortByDescription() {
        ArrayList sorted = Lists.newArrayList(this.getScenarios());
        Collections.sort(sorted, new Comparator<ScenarioModel>(){

            @Override
            public int compare(ScenarioModel o1, ScenarioModel o2) {
                return o1.getDescription().toLowerCase().compareTo(o2.getDescription().toLowerCase());
            }
        });
        return sorted;
    }

    public ScenarioModel getLastScenarioModel() {
        return this.getScenarios().get(this.getScenarios().size() - 1);
    }

    public Optional<ScenarioModel> findScenarioModel(String scenarioDescription) {
        for (ScenarioModel model : this.getScenarios()) {
            if (!model.getDescription().equals(scenarioDescription)) continue;
            return Optional.of((Object)model);
        }
        return Optional.absent();
    }

    public StepModel getFirstStepModelOfLastScenario() {
        return this.getLastScenarioModel().getCase(0).getStep(0);
    }

    public synchronized void addScenarioModel(ScenarioModel currentScenarioModel) {
        this.scenarios.add(currentScenarioModel);
    }

    public String getSimpleClassName() {
        return (String)Iterables.getLast((Iterable)Splitter.on((char)'.').split((CharSequence)this.getClassName()));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<ScenarioModel> getScenarios() {
        return this.scenarios;
    }

    public void setScenarios(List<ScenarioModel> scenarios) {
        this.scenarios = scenarios;
    }

    public String getPackageName() {
        int index = this.className.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return this.className.substring(0, index);
    }

    public List<ScenarioModel> getFailedScenarios() {
        return this.getScenariosWithStatus(ExecutionStatus.FAILED, new ExecutionStatus[0]);
    }

    public List<ScenarioModel> getPendingScenarios() {
        return this.getScenariosWithStatus(ExecutionStatus.SCENARIO_PENDING, ExecutionStatus.SOME_STEPS_PENDING);
    }

    public List<ScenarioModel> getScenariosWithStatus(ExecutionStatus first, ExecutionStatus ... rest) {
        EnumSet<ExecutionStatus[]> stati = EnumSet.of(first, rest);
        ArrayList result = Lists.newArrayList();
        for (ScenarioModel m : this.scenarios) {
            ExecutionStatus executionStatus = m.getExecutionStatus();
            if (!stati.contains((Object)executionStatus)) continue;
            result.add(m);
        }
        return result;
    }

    public synchronized void addTag(Tag tag) {
        this.tagMap.put(tag.toIdString(), tag);
    }

    public synchronized void addTags(List<Tag> tags) {
        for (Tag tag : tags) {
            this.addTag(tag);
        }
    }

    public synchronized Tag getTagWithId(String tagId) {
        Tag tag = this.tagMap.get(tagId);
        AssertionUtil.assertNotNull(tag, "Could not find tag with id " + tagId);
        return tag;
    }

    public synchronized Map<String, Tag> getTagMap() {
        return this.tagMap;
    }

    public synchronized void setTagMap(Map<String, Tag> tagMap) {
        this.tagMap = tagMap;
    }

    public synchronized void addScenarioModelOrMergeWithExistingOne(ScenarioModel scenarioModel) {
        scenarioModel.setClassName(this.getClassName());
        Optional<ScenarioModel> existingScenarioModel = this.findScenarioModel(scenarioModel.getDescription());
        if (existingScenarioModel.isPresent()) {
            AssertionUtil.assertTrue(scenarioModel.getScenarioCases().size() == 1, "ScenarioModel has more than one case");
            ((ScenarioModel)existingScenarioModel.get()).addCase(scenarioModel.getCase(0));
            ((ScenarioModel)existingScenarioModel.get()).addDurationInNanos(scenarioModel.getDurationInNanos());
        } else {
            this.addScenarioModel(scenarioModel);
        }
    }

    public synchronized void setTestClass(Class<?> testClass) {
        As as;
        AssertionUtil.assertTrue(this.className == null || testClass.getName().equals(this.className), "Test class of the same report model was set to different values. 1st value: " + this.className + ", 2nd value: " + testClass.getName());
        this.setClassName(testClass.getName());
        if (testClass.isAnnotationPresent(Description.class)) {
            this.setDescription(testClass.getAnnotation(Description.class).value());
        }
        AsProvider provider = (as = testClass.getAnnotation(As.class)) != null ? ReflectionUtil.newInstance(as.provider()) : new DefaultAsProvider();
        this.name = provider.as(as, testClass);
    }

    public String getName() {
        return this.name;
    }
}

