/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelFile;
import com.tngtech.jgiven.report.model.ReportStatistics;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StatisticsCalculator;
import com.tngtech.jgiven.report.model.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompleteReportModel {
    protected final List<ReportModelFile> models = Lists.newArrayList();
    protected final Map<Tag, List<ScenarioModel>> tagMap = Maps.newHashMap();
    protected final Map<ReportModelFile, ReportStatistics> statisticsMap = Maps.newHashMap();
    protected ReportStatistics totalStatistics = new ReportStatistics();
    protected final List<ScenarioModel> failedScenarios = Lists.newArrayList();
    protected final List<ScenarioModel> pendingScenarios = Lists.newArrayList();
    protected final List<ScenarioModel> allScenarios = Lists.newArrayList();
    protected final Map<String, Tag> tagIdMap = Maps.newLinkedHashMap();

    public void addModelFile(ReportModelFile modelFile) {
        ReportModel model = modelFile.model;
        for (ScenarioModel scenario : model.getScenarios()) {
            for (String tagId : scenario.getTagIds()) {
                Tag tag = model.getTagWithId(tagId);
                this.addToMap(tag, scenario);
            }
        }
        this.tagIdMap.putAll(model.getTagMap());
        ReportStatistics statistics = new StatisticsCalculator().getStatistics(model);
        this.statisticsMap.put(modelFile, statistics);
        this.totalStatistics = this.totalStatistics.add(statistics);
        this.models.add(modelFile);
        this.failedScenarios.addAll(model.getFailedScenarios());
        this.pendingScenarios.addAll(model.getPendingScenarios());
        this.allScenarios.addAll(model.getScenarios());
    }

    private void addToMap(Tag tag, ScenarioModel scenario) {
        ArrayList list = this.tagMap.get(tag);
        if (list == null) {
            list = Lists.newArrayList();
            this.tagMap.put(tag, list);
        }
        list.add(scenario);
    }

    public List<ScenarioModel> getFailedScenarios() {
        return this.failedScenarios;
    }

    public List<ScenarioModel> getPendingScenarios() {
        return this.pendingScenarios;
    }

    public List<ScenarioModel> getAllScenarios() {
        return this.allScenarios;
    }

    public ReportStatistics getTotalStatistics() {
        return this.totalStatistics;
    }

    public ReportStatistics getStatistics(ReportModelFile reportModelFile) {
        return this.statisticsMap.get(reportModelFile);
    }

    public Set<Tag> getAllTags() {
        return this.tagMap.keySet();
    }

    public List<ScenarioModel> getScenariosByTag(Tag tag) {
        return this.tagMap.get(tag);
    }

    public List<ReportModelFile> getAllReportModels() {
        return this.models;
    }

    public Map<String, Tag> getTagIdMap() {
        return this.tagIdMap;
    }
}

