/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class FieldCache {
    private static final ConcurrentHashMap<Class<?>, FieldCache> instances = new ConcurrentHashMap();
    private final Class<?> clazz;
    private final ConcurrentHashMap<List<Class<? extends Annotation>>, List<Field>> fieldMap = new ConcurrentHashMap();

    public static FieldCache get(Class<?> clazz) {
        FieldCache fieldCache = instances.get(clazz);
        if (fieldCache == null) {
            fieldCache = new FieldCache(clazz);
            instances.put(clazz, fieldCache);
        }
        return fieldCache;
    }

    public FieldCache(Class<?> clazz) {
        this.clazz = clazz;
    }

    public List<Field> getFieldsWithAnnotation(Class<? extends Annotation> ... scenarioStageClasses) {
        ImmutableList annotationList = ImmutableList.copyOf((Object[])scenarioStageClasses);
        List<Field> fields = this.fieldMap.get(annotationList);
        if (fields == null) {
            final ArrayList newFields = Lists.newArrayList();
            ReflectionUtil.forEachField(null, this.clazz, ReflectionUtil.hasAtLeastOneAnnotation(scenarioStageClasses), new ReflectionUtil.FieldAction(){

                @Override
                public void act(Object object, Field field) throws Exception {
                    field.setAccessible(true);
                    newFields.add(field);
                }
            });
            this.fieldMap.put((List<Class<? extends Annotation>>)annotationList, newFields);
            return newFields;
        }
        return fields;
    }
}

