/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.params;

import com.tngtech.jgiven.annotation.CaseDescriptionProvider;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultCaseDescriptionProvider
implements CaseDescriptionProvider {
    private static final Pattern pattern = Pattern.compile("\\$(\\d+|\\$)?");

    @Override
    public String description(String value, List<String> parameterNames, List<?> parameterValues) {
        if (value.equals(" - no value - ")) {
            return DefaultCaseDescriptionProvider.defaultDescription(parameterNames, parameterValues);
        }
        Matcher matcher = pattern.matcher(value);
        int placeHolderCounter = 0;
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            String group = matcher.group(1);
            if (group == null) {
                replacement = String.valueOf(parameterValues.get(placeHolderCounter));
                ++placeHolderCounter;
            } else if (group.equals("$")) {
                replacement = "\\$";
            } else {
                int i = Integer.parseInt(group);
                replacement = Matcher.quoteReplacement(String.valueOf(parameterValues.get(i)));
            }
            matcher.appendReplacement(result, replacement);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String defaultDescription(List<String> parameterNames, List<?> parameterValues) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parameterValues.size(); ++i) {
            if (i < parameterNames.size()) {
                sb.append(parameterNames.get(i));
                sb.append(" = ");
            }
            sb.append(parameterValues.get(i));
            if (i == parameterValues.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

