/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.params;

import com.tngtech.jgiven.annotation.As;
import com.tngtech.jgiven.annotation.AsProvider;
import com.tngtech.jgiven.config.AbstractJGivenConfiguration;
import com.tngtech.jgiven.config.ConfigurationUtil;
import com.tngtech.jgiven.impl.util.WordUtil;
import java.lang.reflect.Method;

public class DefaultAsProvider
implements AsProvider {
    @Override
    public String as(As annotation, Method method) {
        if (annotation != null && this.annotationHasExplicitValue(annotation)) {
            return annotation.value();
        }
        return this.methodNameToReadableText(method.getName());
    }

    String methodNameToReadableText(String methodName) {
        if (methodName.contains("_")) {
            return WordUtil.fromSnakeCase(methodName);
        }
        if (WordUtil.isAllUpperCase(methodName)) {
            return methodName;
        }
        return WordUtil.camelCaseToReadableText(methodName);
    }

    @Override
    public String as(As annotation, Class<?> scenarioClass) {
        if (annotation != null && this.annotationHasExplicitValue(annotation)) {
            return annotation.value();
        }
        AbstractJGivenConfiguration configuration = ConfigurationUtil.getConfiguration(scenarioClass);
        String regEx = configuration.getTestClassSuffixRegEx();
        String classNameWithoutSuffix = scenarioClass.getSimpleName().replaceAll(regEx + "$", "");
        return WordUtil.splitCamelCaseToReadableText(classNameWithoutSuffix);
    }

    private boolean annotationHasExplicitValue(As annotation) {
        return !" - no value - ".equals(annotation.value());
    }
}

