/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.format;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.tngtech.jgiven.format.DefaultFormatter;
import com.tngtech.jgiven.format.Formatter;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class FormatterCache {
    private final Map<Class<?>, Formatter<?>> configuredFormatter = Maps.newHashMap();
    private final LoadingCache<Class<?>, Formatter<?>> cache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Formatter<?>>(){

        public Formatter<?> load(Class<?> typeToBeFormatted) throws Exception {
            if (FormatterCache.this.configuredFormatter.containsKey(typeToBeFormatted)) {
                return (Formatter)FormatterCache.this.configuredFormatter.get(typeToBeFormatted);
            }
            if (typeToBeFormatted == Object.class) {
                return DefaultFormatter.INSTANCE;
            }
            Class<?> superClass = typeToBeFormatted;
            while ((superClass = superClass.getSuperclass()) != null && superClass != Object.class) {
                Formatter f = (Formatter)FormatterCache.this.cache.get(superClass);
                if (f == FormatterCache.this.cache.get(Object.class)) continue;
                return f;
            }
            return this.getFormatter(typeToBeFormatted, typeToBeFormatted.getInterfaces());
        }

        private Formatter<?> getFormatter(Class<?> typeToBeFormatted, Class<?>[] interfaces) throws ExecutionException {
            Formatter<?> f;
            Formatter objectFormatter = (Formatter)FormatterCache.this.cache.get(Object.class);
            for (Class<?> i : interfaces) {
                f = (Formatter<?>)FormatterCache.this.cache.get(i);
                if (f == objectFormatter) continue;
                return f;
            }
            for (Class<?> i : interfaces) {
                f = this.getFormatter(typeToBeFormatted, i.getInterfaces());
                if (f == objectFormatter) continue;
                return f;
            }
            return objectFormatter;
        }
    });

    public <T> void setFormatter(Class<T> typeToBeFormatted, Formatter<? super T> formatter) {
        this.configuredFormatter.put(typeToBeFormatted, formatter);
    }

    public <T> Formatter<? super T> getFormatter(Class<T> typeToBeFormatted) {
        if (this.configuredFormatter.isEmpty()) {
            return DefaultFormatter.INSTANCE;
        }
        try {
            return (Formatter)this.cache.get(typeToBeFormatted);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }
}

