/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.jsonrpc2.server;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Notification;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import com.thetransactioncompany.jsonrpc2.server.MessageContext;
import com.thetransactioncompany.jsonrpc2.server.NotificationHandler;
import com.thetransactioncompany.jsonrpc2.server.RequestHandler;
import java.util.Hashtable;

public class Dispatcher
implements RequestHandler,
NotificationHandler {
    private Hashtable<String, RequestHandler> requestHandlers = new Hashtable();
    private Hashtable<String, NotificationHandler> notificationHandlers = new Hashtable();
    private boolean reportProcTime = false;

    public void register(RequestHandler handler) {
        for (String name : handler.handledRequests()) {
            if (this.requestHandlers.containsKey(name)) {
                throw new IllegalArgumentException("Cannot register a duplicate JSON-RPC 2.0 handler for request " + name);
            }
            this.requestHandlers.put(name, handler);
        }
    }

    public void register(NotificationHandler handler) {
        for (String name : handler.handledNotifications()) {
            if (this.notificationHandlers.containsKey(name)) {
                throw new IllegalArgumentException("Cannot register a duplicate JSON-RPC 2.0 handler for notification " + name);
            }
            this.notificationHandlers.put(name, handler);
        }
    }

    @Override
    public String[] handledRequests() {
        return this.requestHandlers.keySet().toArray(new String[0]);
    }

    @Override
    public String[] handledNotifications() {
        return this.notificationHandlers.keySet().toArray(new String[0]);
    }

    public RequestHandler getRequestHandler(String requestName) {
        return this.requestHandlers.get(requestName);
    }

    public NotificationHandler getNotificationHandler(String notificationName) {
        return this.notificationHandlers.get(notificationName);
    }

    public JSONRPC2Response dispatch(JSONRPC2Request request, MessageContext requestCtx) {
        return this.process(request, requestCtx);
    }

    @Override
    public JSONRPC2Response process(JSONRPC2Request request, MessageContext requestCtx) {
        String method;
        RequestHandler handler;
        long startNanosec = 0L;
        if (this.reportProcTime) {
            startNanosec = System.nanoTime();
        }
        if ((handler = this.getRequestHandler(method = request.getMethod())) == null) {
            Object id = request.getID();
            return new JSONRPC2Response(JSONRPC2Error.METHOD_NOT_FOUND, id);
        }
        JSONRPC2Response response = handler.process(request, requestCtx);
        if (this.reportProcTime) {
            long procTimeNanosec = System.nanoTime() - startNanosec;
            response.appendNonStdAttribute("xProcTime", (Object)(procTimeNanosec / 1000L + " us"));
        }
        return response;
    }

    public void dispatch(JSONRPC2Notification notification, MessageContext notificationCtx) {
        this.process(notification, notificationCtx);
    }

    @Override
    public void process(JSONRPC2Notification notification, MessageContext notificationCtx) {
        String method = notification.getMethod();
        NotificationHandler handler = this.getNotificationHandler(method);
        if (handler == null) {
            return;
        }
        handler.process(notification, notificationCtx);
    }

    public void reportProcTime(boolean enable) {
        this.reportProcTime = enable;
    }

    public boolean reportsProcTime() {
        return this.reportProcTime;
    }
}

