/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2gss;

import com.teradata.tdgss.jgssp2gss.GssMinorStatus;
import com.teradata.tdgss.jtdgss.TdgssException;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class GssLogin
implements PrivilegedExceptionAction {
    private String user;
    private String password;
    private GSSName gssName;
    private Oid mechOid;
    private int lifetime;
    private int usage;
    private GSSCredential myCred = null;
    private GSSManager mgr = null;

    public GssLogin(String string, String string2, GSSName gSSName, Oid oid, int n, int n2) {
        this.user = string;
        this.password = string2;
        this.gssName = gSSName;
        this.mechOid = oid;
        this.lifetime = n;
        this.usage = n2;
        this.mgr = GSSManager.getInstance();
    }

    public GSSCredential login() throws GSSException {
        if (this.user != null && this.user.length() > 0 && this.password != null && this.password.length() > 0) {
            try {
                TeraCallbackHandler teraCallbackHandler = new TeraCallbackHandler(this.user, this.password);
                LoginContext loginContext = new LoginContext(this.getClass().getName(), teraCallbackHandler);
                loginContext.login();
                Subject.doAs(loginContext.getSubject(), this);
            }
            catch (Exception exception) {
                throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_INVALID_INPUT, exception);
            }
        } else {
            this.myCred = this.mgr.createCredential(this.gssName, this.lifetime, this.mechOid, this.usage);
        }
        return this.myCred;
    }

    public Object run() throws Exception {
        this.myCred = this.mgr.createCredential(this.gssName, this.lifetime, this.mechOid, this.usage);
        return this.myCred;
    }

    public class TeraCallbackHandler
    implements CallbackHandler {
        String name = null;
        String password = null;

        public TeraCallbackHandler(String string, String string2) {
            this.name = string;
            this.password = string2;
        }

        @Override
        public void handle(Callback[] callbackArray) throws UnsupportedCallbackException, IOException {
            for (int i = 0; i < callbackArray.length; ++i) {
                Callback callback;
                Callback callback2 = callbackArray[i];
                if (callback2 instanceof NameCallback) {
                    callback = (NameCallback)callback2;
                    ((NameCallback)callback).setName(this.name);
                    continue;
                }
                if (!(callback2 instanceof PasswordCallback)) continue;
                callback = (PasswordCallback)callback2;
                ((PasswordCallback)callback).setPassword(this.password.toCharArray());
            }
        }
    }
}

