/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.DeferredLob;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.sql.SQLException;

public class DeferredBlob
extends DeferredLob {
    private InputStream m_istream;

    public DeferredBlob(InputStream inputStream, long l) {
        this.m_istream = inputStream;
        this.m_nLength = l;
    }

    @Override
    public int writeDeferredLob(TDPacketStream tDPacketStream, int n) throws IOException, SQLException {
        if (this.m_byteBuf != null) {
            tDPacketStream.put(this.m_byteBuf.array(), 0, this.m_byteBuf.position());
            return this.m_byteBuf.position();
        }
        n = (int)(this.m_nLength < (long)n ? this.m_nLength : (long)n);
        int n2 = tDPacketStream.putInputStream(this.m_istream, n);
        this.m_nAmountRead += (long)n2;
        if (this.m_nAmountRead == this.m_nLength || n2 == 0) {
            this.m_bAtEof = true;
        }
        return n2;
    }

    @Override
    public int readDeferredLob(int n) throws IOException, SQLException {
        this.m_byteBuf = ByteBuffer.allocate((int)this.m_nLength);
        int n2 = this.m_istream.read(this.m_byteBuf.array(), 0, (int)this.m_nLength);
        this.m_nAmountRead += n2 == -1 ? 0L : (long)n2;
        this.m_byteBuf.position((int)this.m_nAmountRead);
        return (int)this.m_nAmountRead;
    }
}

