/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastload;

import com.teradata.jdbc.jdbc.fastload.FastLoadPreparedStatement;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;

public class FastLoadSQLOutput
implements SQLOutput {
    private int m_nAttributeIndex = 0;
    private FastLoadPreparedStatement.PeriodValue m_periodValue;
    private int[] m_anSqlDataTypes;
    private int m_nParameterIndex;
    private String m_sAppName;

    public FastLoadSQLOutput(FastLoadPreparedStatement fastLoadPreparedStatement, ArrayList arrayList, int n, String string, String string2) throws SQLException {
        this.m_nParameterIndex = n;
        this.m_sAppName = string;
        FastLoadPreparedStatement.AttributeMetaData attributeMetaData = new FastLoadPreparedStatement.AttributeMetaData(fastLoadPreparedStatement, arrayList, n, string, string2);
        this.m_periodValue = new FastLoadPreparedStatement.PeriodValue(attributeMetaData);
        this.m_anSqlDataTypes = attributeMetaData.getSQLDataType();
    }

    private void verifyAttribute(String string, int[] nArray) throws SQLException {
        String string2 = this.m_sAppName + ".writeSQL";
        string = "SQLOutput." + string;
        if (this.m_nAttributeIndex >= this.m_anSqlDataTypes.length) {
            throw ErrorFactory.makeDriverJDBCException("TJ682", string2, String.valueOf(this.m_nAttributeIndex + 1), String.valueOf(this.m_anSqlDataTypes.length));
        }
        int n = this.m_anSqlDataTypes[this.m_nAttributeIndex];
        boolean bl = false;
        for (int i = 0; !bl && i < nArray.length; ++i) {
            bl = n == nArray[i];
        }
        if (!bl) {
            throw ErrorFactory.makeDriverJDBCException("TJ681", string2, string, JDBC4Constants.getJavaSQLTypeName(n));
        }
    }

    protected Object getObject() throws SQLException {
        if (this.m_nAttributeIndex < this.m_anSqlDataTypes.length) {
            throw ErrorFactory.makeDriverJDBCException("TJ682", this.m_sAppName + ".writeSQL", String.valueOf(this.m_nAttributeIndex), String.valueOf(this.m_anSqlDataTypes.length));
        }
        return this.m_periodValue.isNull() ? new FastLoadPreparedStatement.TypedNull(this.m_periodValue) : this.m_periodValue;
    }

    @Override
    public void writeString(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeShort(short s) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeInt(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeLong(long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        this.verifyAttribute("writeDate", new int[]{91});
        this.m_periodValue.setPeriodDate(this.m_nParameterIndex, date, null);
        ++this.m_nAttributeIndex;
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        this.verifyAttribute("writeTime", new int[]{92});
        this.m_periodValue.setPeriodTime(this.m_nParameterIndex, time, null);
        ++this.m_nAttributeIndex;
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.verifyAttribute("writeTimestamp", new int[]{93});
        this.m_periodValue.setPeriodTimestamp(this.m_nParameterIndex, timestamp, null);
        ++this.m_nAttributeIndex;
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeNString(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }
}

