/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tcaplusdb.v20190823.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class SetTableIndexRequest extends AbstractModel{

    /**
    * 表所属集群实例ID
    */
    @SerializedName("ClusterId")
    @Expose
    private String ClusterId;

    /**
    * 待创建分布式索引表格列表
    */
    @SerializedName("SelectedTables")
    @Expose
    private SelectedTableWithField [] SelectedTables;

    /**
     * Get 表所属集群实例ID 
     * @return ClusterId 表所属集群实例ID
     */
    public String getClusterId() {
        return this.ClusterId;
    }

    /**
     * Set 表所属集群实例ID
     * @param ClusterId 表所属集群实例ID
     */
    public void setClusterId(String ClusterId) {
        this.ClusterId = ClusterId;
    }

    /**
     * Get 待创建分布式索引表格列表 
     * @return SelectedTables 待创建分布式索引表格列表
     */
    public SelectedTableWithField [] getSelectedTables() {
        return this.SelectedTables;
    }

    /**
     * Set 待创建分布式索引表格列表
     * @param SelectedTables 待创建分布式索引表格列表
     */
    public void setSelectedTables(SelectedTableWithField [] SelectedTables) {
        this.SelectedTables = SelectedTables;
    }

    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "ClusterId", this.ClusterId);
        this.setParamArrayObj(map, prefix + "SelectedTables.", this.SelectedTables);

    }
}

