/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.mps.v20190612.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class ManageTaskRequest extends AbstractModel{

    /**
    * 操作类型，取值范围：
<li>Abort：终止任务。</li>
    */
    @SerializedName("OperationType")
    @Expose
    private String OperationType;

    /**
    * 视频处理的任务 ID。
    */
    @SerializedName("TaskId")
    @Expose
    private String TaskId;

    /**
     * Get 操作类型，取值范围：
<li>Abort：终止任务。</li> 
     * @return OperationType 操作类型，取值范围：
<li>Abort：终止任务。</li>
     */
    public String getOperationType() {
        return this.OperationType;
    }

    /**
     * Set 操作类型，取值范围：
<li>Abort：终止任务。</li>
     * @param OperationType 操作类型，取值范围：
<li>Abort：终止任务。</li>
     */
    public void setOperationType(String OperationType) {
        this.OperationType = OperationType;
    }

    /**
     * Get 视频处理的任务 ID。 
     * @return TaskId 视频处理的任务 ID。
     */
    public String getTaskId() {
        return this.TaskId;
    }

    /**
     * Set 视频处理的任务 ID。
     * @param TaskId 视频处理的任务 ID。
     */
    public void setTaskId(String TaskId) {
        this.TaskId = TaskId;
    }

    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "OperationType", this.OperationType);
        this.setParamSimple(map, prefix + "TaskId", this.TaskId);

    }
}

