/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.bmlb.v20180625.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeLoadBalancerTaskResultRequest extends AbstractModel{

    /**
    * 任务ID。由具体的异步操作接口提供。
    */
    @SerializedName("TaskId")
    @Expose
    private String TaskId;

    /**
     * Get 任务ID。由具体的异步操作接口提供。 
     * @return TaskId 任务ID。由具体的异步操作接口提供。
     */
    public String getTaskId() {
        return this.TaskId;
    }

    /**
     * Set 任务ID。由具体的异步操作接口提供。
     * @param TaskId 任务ID。由具体的异步操作接口提供。
     */
    public void setTaskId(String TaskId) {
        this.TaskId = TaskId;
    }

    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "TaskId", this.TaskId);

    }
}

