/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.spring.schema;

import com.qq.tars.spring.config.ListenerConfig;
import com.qq.tars.spring.config.ServantConfig;
import com.qq.tars.spring.config.TarsSpringConfigException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TarsBeanDefinitionParser
implements BeanDefinitionParser {
    private Class<?> clssze;

    TarsBeanDefinitionParser(Class<?> cls) {
        this.clssze = cls;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(this.clssze);
        String id = null;
        id = element.getAttribute("name");
        if (id == null || id.length() == 0) {
            if (this.clssze == ServantConfig.class) {
                throw new TarsSpringConfigException("Messing servant name");
            }
            if (this.clssze == ListenerConfig.class) {
                id = "listener";
                int counter = 0;
                while (parserContext.getRegistry().containsBeanDefinition(id + counter)) {
                    ++counter;
                }
                id = id + counter;
            }
        }
        if (id != null && id.length() > 0) {
            if (parserContext.getRegistry().containsBeanDefinition(id)) {
                throw new TarsSpringConfigException("Duplicate spring bean id " + id);
            }
            parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        }
        NamedNodeMap nnm = element.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node node = nnm.item(i);
            String key = node.getLocalName();
            String value = node.getNodeValue();
            if (key.equals("entity")) {
                if (parserContext.getRegistry().containsBeanDefinition(value)) {
                    beanDefinition.getPropertyValues().add(key, (Object)parserContext.getRegistry().getBeanDefinition(value));
                    continue;
                }
                beanDefinition.getPropertyValues().add(key, (Object)new RuntimeBeanReference(value));
                continue;
            }
            beanDefinition.getPropertyValues().add(key, (Object)value);
        }
        return beanDefinition;
    }
}

