/**
 * Tencent is pleased to support the open source community by making Tars available.
 *
 * Copyright (C) 2016 THL A29 Limited, a Tencent company. All rights reserved.
 *
 * Licensed under the BSD 3-Clause License (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * https://opensource.org/licenses/BSD-3-Clause
 *
 * Unless required by applicable law or agreed to in writing, software distributed
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
// **********************************************************************
// This file was generated by a TARS parser!
// TARS version 1.0.1.
// **********************************************************************

package com.qq.tars.support.stat.prx;

import com.qq.tars.protocol.tars.TarsInputStream;
import com.qq.tars.protocol.tars.TarsOutputStream;
import com.qq.tars.protocol.tars.annotation.TarsStruct;
import com.qq.tars.protocol.tars.annotation.TarsStructProperty;
import com.qq.tars.protocol.util.TarsUtil;

@TarsStruct
public class StatMicMsgHead implements Comparable<StatMicMsgHead> {

	@TarsStructProperty(order = 0, isRequire = true)
	public String masterName = "";
	@TarsStructProperty(order = 1, isRequire = true)
	public String slaveName = "";
	@TarsStructProperty(order = 2, isRequire = true)
	public String interfaceName = "";
	@TarsStructProperty(order = 3, isRequire = true)
	public String masterIp = "";
	@TarsStructProperty(order = 4, isRequire = true)
	public String slaveIp = "";
	@TarsStructProperty(order = 5, isRequire = true)
	public int slavePort = 0;
	@TarsStructProperty(order = 6, isRequire = true)
	public int returnValue = 0;
	@TarsStructProperty(order = 7, isRequire = false)
	public String slaveSetName = "";
	@TarsStructProperty(order = 8, isRequire = false)
	public String slaveSetArea = "";
	@TarsStructProperty(order = 9, isRequire = false)
	public String slaveSetID = "";
	@TarsStructProperty(order = 10, isRequire = false)
	public String tarsVersion = "";

	public String getMasterName() {
		return masterName;
	}

	public void setMasterName(String masterName) {
		this.masterName = masterName;
	}

	public String getSlaveName() {
		return slaveName;
	}

	public void setSlaveName(String slaveName) {
		this.slaveName = slaveName;
	}

	public String getInterfaceName() {
		return interfaceName;
	}

	public void setInterfaceName(String interfaceName) {
		this.interfaceName = interfaceName;
	}

	public String getMasterIp() {
		return masterIp;
	}

	public void setMasterIp(String masterIp) {
		this.masterIp = masterIp;
	}

	public String getSlaveIp() {
		return slaveIp;
	}

	public void setSlaveIp(String slaveIp) {
		this.slaveIp = slaveIp;
	}

	public int getSlavePort() {
		return slavePort;
	}

	public void setSlavePort(int slavePort) {
		this.slavePort = slavePort;
	}

	public int getReturnValue() {
		return returnValue;
	}

	public void setReturnValue(int returnValue) {
		this.returnValue = returnValue;
	}

	public String getSlaveSetName() {
		return slaveSetName;
	}

	public void setSlaveSetName(String slaveSetName) {
		this.slaveSetName = slaveSetName;
	}

	public String getSlaveSetArea() {
		return slaveSetArea;
	}

	public void setSlaveSetArea(String slaveSetArea) {
		this.slaveSetArea = slaveSetArea;
	}

	public String getSlaveSetID() {
		return slaveSetID;
	}

	public void setSlaveSetID(String slaveSetID) {
		this.slaveSetID = slaveSetID;
	}

	public String getTarsVersion() {
		return tarsVersion;
	}

	public void setTarsVersion(String tarsVersion) {
		this.tarsVersion = tarsVersion;
	}

	public StatMicMsgHead() {
	}

	public StatMicMsgHead(String masterName, String slaveName, String interfaceName, String masterIp, String slaveIp, int slavePort, int returnValue, String slaveSetName, String slaveSetArea, String slaveSetID, String tarsVersion) {
		this.masterName = masterName;
		this.slaveName = slaveName;
		this.interfaceName = interfaceName;
		this.masterIp = masterIp;
		this.slaveIp = slaveIp;
		this.slavePort = slavePort;
		this.returnValue = returnValue;
		this.slaveSetName = slaveSetName;
		this.slaveSetArea = slaveSetArea;
		this.slaveSetID = slaveSetID;
		this.tarsVersion = tarsVersion;
	}

	@Override
	public int compareTo(StatMicMsgHead o) {
		int c = 0;
		if((c = TarsUtil.compareTo(masterName, o.masterName)) != 0 ) {
			return c;
		}
		if((c = TarsUtil.compareTo(slaveName, o.slaveName)) != 0 ) {
			return c;
		}
		if((c = TarsUtil.compareTo(interfaceName, o.interfaceName)) != 0 ) {
			return c;
		}
		if((c = TarsUtil.compareTo(masterIp, o.masterIp)) != 0 ) {
			return c;
		}
		if((c = TarsUtil.compareTo(slaveIp, o.slaveIp)) != 0 ) {
			return c;
		}
		if((c = TarsUtil.compareTo(slavePort, o.slavePort)) != 0 ) {
			return c;
		}
		if((c = TarsUtil.compareTo(returnValue, o.returnValue)) != 0 ) {
			return c;
		}
		if((c = TarsUtil.compareTo(slaveSetName, o.slaveSetName)) != 0 ) {
			return c;
		}
		if((c = TarsUtil.compareTo(slaveSetArea, o.slaveSetArea)) != 0 ) {
			return c;
		}
		if((c = TarsUtil.compareTo(slaveSetID, o.slaveSetID)) != 0 ) {
			return c;
		}
		if((c = TarsUtil.compareTo(tarsVersion, o.tarsVersion)) != 0 ) {
			return c;
		}
		return 0;
	}


	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + TarsUtil.hashCode(masterName);
		result = prime * result + TarsUtil.hashCode(slaveName);
		result = prime * result + TarsUtil.hashCode(interfaceName);
		result = prime * result + TarsUtil.hashCode(masterIp);
		result = prime * result + TarsUtil.hashCode(slaveIp);
		result = prime * result + TarsUtil.hashCode(slavePort);
		result = prime * result + TarsUtil.hashCode(returnValue);
		result = prime * result + TarsUtil.hashCode(slaveSetName);
		result = prime * result + TarsUtil.hashCode(slaveSetArea);
		result = prime * result + TarsUtil.hashCode(slaveSetID);
		result = prime * result + TarsUtil.hashCode(tarsVersion);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof StatMicMsgHead)) {
			return false;
		}
		StatMicMsgHead other = (StatMicMsgHead) obj;
		return (
			TarsUtil.equals(masterName, other.masterName) &&
			TarsUtil.equals(slaveName, other.slaveName) &&
			TarsUtil.equals(interfaceName, other.interfaceName) &&
			TarsUtil.equals(masterIp, other.masterIp) &&
			TarsUtil.equals(slaveIp, other.slaveIp) &&
			TarsUtil.equals(slavePort, other.slavePort) &&
			TarsUtil.equals(returnValue, other.returnValue) &&
			TarsUtil.equals(slaveSetName, other.slaveSetName) &&
			TarsUtil.equals(slaveSetArea, other.slaveSetArea) &&
			TarsUtil.equals(slaveSetID, other.slaveSetID) &&
			TarsUtil.equals(tarsVersion, other.tarsVersion) 
		);
	}

	public void writeTo(TarsOutputStream _os) {
		if (null != masterName) {
			_os.write(masterName, 0);
		}
		if (null != slaveName) {
			_os.write(slaveName, 1);
		}
		if (null != interfaceName) {
			_os.write(interfaceName, 2);
		}
		if (null != masterIp) {
			_os.write(masterIp, 3);
		}
		if (null != slaveIp) {
			_os.write(slaveIp, 4);
		}
		_os.write(slavePort, 5);
		_os.write(returnValue, 6);
		if (null != slaveSetName) {
			_os.write(slaveSetName, 7);
		}
		if (null != slaveSetArea) {
			_os.write(slaveSetArea, 8);
		}
		if (null != slaveSetID) {
			_os.write(slaveSetID, 9);
		}
		if (null != tarsVersion) {
			_os.write(tarsVersion, 10);
		}
	}

	public void readFrom(TarsInputStream _is) {
		this.masterName = _is.read(masterName, 0, true);
		this.slaveName = _is.read(slaveName, 1, true);
		this.interfaceName = _is.read(interfaceName, 2, true);
		this.masterIp = _is.read(masterIp, 3, true);
		this.slaveIp = _is.read(slaveIp, 4, true);
		this.slavePort = _is.read(slavePort, 5, true);
		this.returnValue = _is.read(returnValue, 6, true);
		this.slaveSetName = _is.read(slaveSetName, 7, false);
		this.slaveSetArea = _is.read(slaveSetArea, 8, false);
		this.slaveSetID = _is.read(slaveSetID, 9, false);
		this.tarsVersion = _is.read(tarsVersion, 10, false);
	}

}
