/**
 * Tencent is pleased to support the open source community by making Tars available.
 *
 * Copyright (C) 2016 THL A29 Limited, a Tencent company. All rights reserved.
 *
 * Licensed under the BSD 3-Clause License (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * https://opensource.org/licenses/BSD-3-Clause
 *
 * Unless required by applicable law or agreed to in writing, software distributed
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
// **********************************************************************
// This file was generated by a TARS parser!
// TARS version 1.0.1.
// **********************************************************************

package com.qq.tars.support.query.prx;

import com.qq.tars.common.support.Holder;
import com.qq.tars.protocol.annotation.Servant;
import com.qq.tars.protocol.tars.annotation.TarsCallback;
import com.qq.tars.protocol.tars.annotation.TarsContext;
import com.qq.tars.protocol.tars.annotation.TarsHolder;

/** 
 * Get the query interface of the object endpoint
 */
@Servant
public interface QueryFPrx {
	/** Get the object by id
	 *
	 * @param id Object name
	 *
	 * @return  Returns a list of all active endpoints for this object
	 */
	public java.util.List<EndpointF> findObjectById(String id);
	/** Get the object by id
	 *
	 * @param id Object name
	 *
	 * @return  Returns a list of all active endpoints for this object
	 */
	public java.util.List<EndpointF> findObjectById(String id, @TarsContext java.util.Map<String, String> ctx);
	/** Get the object by id
	 *
	 * @param id Object name
	 *
	 * @return  Returns a list of all active endpoints for this object
	 */
	public void async_findObjectById(@TarsCallback QueryFPrxCallback callback, String id);
	/** Get the object by id
	 *
	 * @param id Object name
	 *
	 * @return  Returns a list of all active endpoints for this object
	 */
	public void async_findObjectById(@TarsCallback QueryFPrxCallback callback, String id, @TarsContext java.util.Map<String, String> ctx);
	/**Gets all objects by id, both active and inactive
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public int findObjectById4Any(String id, @TarsHolder Holder<java.util.List<EndpointF>> activeEp, @TarsHolder Holder<java.util.List<EndpointF>> inactiveEp);
	/**Gets all objects by id, both active and inactive
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public int findObjectById4Any(String id, @TarsHolder Holder<java.util.List<EndpointF>> activeEp, @TarsHolder Holder<java.util.List<EndpointF>> inactiveEp, @TarsContext java.util.Map<String, String> ctx);
	/**Gets all objects by id, both active and inactive
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public void async_findObjectById4Any(@TarsCallback QueryFPrxCallback callback, String id);
	/**Gets all objects by id, both active and inactive
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public void async_findObjectById4Any(@TarsCallback QueryFPrxCallback callback, String id, @TarsContext java.util.Map<String, String> ctx);
	/** Get all endpoint lists of objects according to id, the function is the same as findObjectByIdInSameGroup
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public int findObjectById4All(String id, @TarsHolder Holder<java.util.List<EndpointF>> activeEp, @TarsHolder Holder<java.util.List<EndpointF>> inactiveEp);
	/** Get all endpoint lists of objects according to id, the function is the same as findObjectByIdInSameGroup
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public int findObjectById4All(String id, @TarsHolder Holder<java.util.List<EndpointF>> activeEp, @TarsHolder Holder<java.util.List<EndpointF>> inactiveEp, @TarsContext java.util.Map<String, String> ctx);
	/** Get all endpoint lists of objects according to id, the function is the same as findObjectByIdInSameGroup
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public void async_findObjectById4All(@TarsCallback QueryFPrxCallback callback, String id);
	/** Get all endpoint lists of objects according to id, the function is the same as findObjectByIdInSameGroup
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public void async_findObjectById4All(@TarsCallback QueryFPrxCallback callback, String id, @TarsContext java.util.Map<String, String> ctx);
	/** Get the same group endpoint list of objects according to id
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public int findObjectByIdInSameGroup(String id, @TarsHolder Holder<java.util.List<EndpointF>> activeEp, @TarsHolder Holder<java.util.List<EndpointF>> inactiveEp);
	/** Get the same group endpoint list of objects according to id
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public int findObjectByIdInSameGroup(String id, @TarsHolder Holder<java.util.List<EndpointF>> activeEp, @TarsHolder Holder<java.util.List<EndpointF>> inactiveEp, @TarsContext java.util.Map<String, String> ctx);
	/** Get the same group endpoint list of objects according to id
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public void async_findObjectByIdInSameGroup(@TarsCallback QueryFPrxCallback callback, String id);
	/** Get the same group endpoint list of objects according to id
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public void async_findObjectByIdInSameGroup(@TarsCallback QueryFPrxCallback callback, String id, @TarsContext java.util.Map<String, String> ctx);
	/** Get the endpoint list of the specified home location of the object according to id
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public int findObjectByIdInSameStation(String id, String sStation, @TarsHolder Holder<java.util.List<EndpointF>> activeEp, @TarsHolder Holder<java.util.List<EndpointF>> inactiveEp);
	/** Get the endpoint list of the specified home location of the object according to id
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public int findObjectByIdInSameStation(String id, String sStation, @TarsHolder Holder<java.util.List<EndpointF>> activeEp, @TarsHolder Holder<java.util.List<EndpointF>> inactiveEp, @TarsContext java.util.Map<String, String> ctx);
	/** Get the endpoint list of the specified home location of the object according to id
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public void async_findObjectByIdInSameStation(@TarsCallback QueryFPrxCallback callback, String id, String sStation);
	/** Get the endpoint list of the specified home location of the object according to id
	 *
	 * @param id         Object name
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public void async_findObjectByIdInSameStation(@TarsCallback QueryFPrxCallback callback, String id, String sStation, @TarsContext java.util.Map<String, String> ctx);
	/** Get the same group endpoint list of objects according to id
	 *
	 * @param id         Object name
	 * @param setId      The full name of set, the format is setname.setarea.setgroup
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public int findObjectByIdInSameSet(String id, String setId, @TarsHolder Holder<java.util.List<EndpointF>> activeEp, @TarsHolder Holder<java.util.List<EndpointF>> inactiveEp);
	/** Get the same group endpoint list of objects according to id
	 *
	 * @param id         Object name
	 * @param setId      The full name of set, the format is setname.setarea.setgroup
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public int findObjectByIdInSameSet(String id, String setId, @TarsHolder Holder<java.util.List<EndpointF>> activeEp, @TarsHolder Holder<java.util.List<EndpointF>> inactiveEp, @TarsContext java.util.Map<String, String> ctx);
	/** Get the same group endpoint list of objects according to id
	 *
	 * @param id         Object name
	 * @param setId      The full name of set, the format is setname.setarea.setgroup
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public void async_findObjectByIdInSameSet(@TarsCallback QueryFPrxCallback callback, String id, String setId);
	/** Get the same group endpoint list of objects according to id
	 *
	 * @param id         Object name
	 * @param setId      The full name of set, the format is setname.setarea.setgroup
	 * @param activeEp   List of live endpoints
	 * @param inactiveEp List of non-live endpoints
	 * @return:  0-success  others-failure
	 */
	public void async_findObjectByIdInSameSet(@TarsCallback QueryFPrxCallback callback, String id, String setId, @TarsContext java.util.Map<String, String> ctx);
}
