/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.common.registry;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PolarisConfig.class);
    private final String namespace;
    private final String registryAddress;
    private final String configAddress;
    private final String token;
    private final int ttl;

    public PolarisConfig(String host, int port, Map<String, String> parameters) {
        this.registryAddress = String.format("%s:%d", host, port);
        this.configAddress = String.format("%s:%d", host, 8093);
        String namespaceStr = parameters.get("namespace");
        if (null == namespaceStr || namespaceStr.length() == 0) {
            namespaceStr = "default";
        }
        this.namespace = namespaceStr;
        this.token = parameters.get("token");
        int healthTTL = 5;
        String ttlStr = System.getProperty("ttl");
        if (null != ttlStr && ttlStr.length() > 0) {
            try {
                healthTTL = Integer.parseInt(ttlStr);
            }
            catch (Exception e) {
                LOG.info("[Common] fail to convert ttlStr {}", (Object)ttlStr, (Object)e);
            }
        }
        this.ttl = healthTTL;
        LOG.info("[Common] construct polarisConfig {}", (Object)this);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRegistryAddress() {
        return this.registryAddress;
    }

    public String getToken() {
        return this.token;
    }

    public String getConfigAddress() {
        return this.configAddress;
    }

    public int getTtl() {
        return this.ttl;
    }

    public String toString() {
        return "PolarisConfig{namespace='" + this.namespace + '\'' + ", registryAddress='" + this.registryAddress + '\'' + ", configAddress='" + this.configAddress + '\'' + ", token='" + this.token + '\'' + ", ttl=" + this.ttl + '}';
    }
}

