/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.common.registry;

import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.StatusDimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ConvertUtils {
    private static final String SEP_CIRCUIT_BREAKER = ",";
    private static final String SEP_CIRCUIT_BREAKER_VALUE = ":";

    public static String circuitBreakersToString(Instance instance) {
        ArrayList<String> values = new ArrayList<String>();
        Collection statusDimensions = instance.getStatusDimensions();
        if (null != statusDimensions && statusDimensions.size() > 0) {
            for (StatusDimension statusDimension : statusDimensions) {
                CircuitBreakerStatus circuitBreakerStatus = instance.getCircuitBreakerStatus(statusDimension);
                if (null == circuitBreakerStatus) continue;
                values.add(statusDimension.getMethod() + SEP_CIRCUIT_BREAKER_VALUE + circuitBreakerStatus.getStatus().name());
            }
        }
        if (values.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)SEP_CIRCUIT_BREAKER, values.toArray(new String[0]));
    }

    public static Map<StatusDimension, CircuitBreakerStatus> stringToCircuitBreakers(String value) {
        String[] tokens;
        HashMap<StatusDimension, CircuitBreakerStatus> values = new HashMap<StatusDimension, CircuitBreakerStatus>();
        if (null == value || value.length() == 0) {
            return values;
        }
        for (String token : tokens = value.split(SEP_CIRCUIT_BREAKER)) {
            String[] splits = token.split(SEP_CIRCUIT_BREAKER_VALUE);
            if (splits.length != 2) continue;
            StatusDimension dimension = new StatusDimension(splits[0], null);
            CircuitBreakerStatus circuitBreakerStatus = new CircuitBreakerStatus("", CircuitBreakerStatus.Status.valueOf((String)splits[1]), 0L);
            values.put(dimension, circuitBreakerStatus);
        }
        return values;
    }
}

