/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.common.parser;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.tencent.polaris.common.parser.QueryParser;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import shade.polaris.com.google.gson.Gson;

class JsonPathQueryParser
implements QueryParser {
    private static final Pattern ARRAY_PATTERN = Pattern.compile("^.+\\[[0-9]+\\]");
    private static final String PREFIX_PARAM = "param";
    private static final String PREFIX_PARAM_ARRAY = "param[";
    private static final Index EMPTY_INDEX = new Index(-1, "");

    JsonPathQueryParser() {
    }

    @Override
    public String name() {
        return "JsonPath";
    }

    @Override
    public Optional<String> parse(String query, Object[] parameters) {
        if (Objects.isNull(parameters) || parameters.length == 0) {
            return Optional.empty();
        }
        Index index = this.resolveIndex(query);
        if (index.index == -1 || index.index > parameters.length) {
            return Optional.empty();
        }
        String str = new Gson().toJson(parameters[index.index]);
        DocumentContext ctx = JsonPath.parse((String)str);
        Object value = ctx.read(index.key, Object.class, new Predicate[0]);
        if (Objects.isNull(value)) {
            return Optional.empty();
        }
        return Optional.of(Objects.toString(value));
    }

    private Index resolveIndex(String key) {
        if (key.startsWith(PREFIX_PARAM_ARRAY)) {
            int endIndex = key.indexOf("]");
            String indexStr = key.substring(PREFIX_PARAM_ARRAY.length(), endIndex);
            int index = Integer.parseInt(indexStr);
            int startIndex = endIndex + 2;
            if (!Objects.equals(Character.valueOf(key.charAt(endIndex + 1)), Character.valueOf('.'))) {
                startIndex = endIndex + 1;
            }
            return new Index(index, key.substring(startIndex));
        }
        if (key.startsWith(PREFIX_PARAM)) {
            return new Index(0, key.replace("param.", ""));
        }
        return EMPTY_INDEX;
    }

    private static final class Index {
        private final int index;
        private final String key;

        public Index(int index, String key) {
            this.index = index;
            this.key = key;
        }
    }
}

