/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.errrate;

import com.tencent.polaris.api.config.consumer.CircuitBreakerConfig;
import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreakResult;
import com.tencent.polaris.api.plugin.circuitbreaker.InstanceCircuitBreaker;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.registry.LocalRegistry;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.pojo.InstanceLocalValue;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.pojo.Subset;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.flow.DefaultFlowControlParam;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.client.pojo.InstanceByProto;
import com.tencent.polaris.plugins.circuitbreaker.common.ChangeStateUtils;
import com.tencent.polaris.plugins.circuitbreaker.common.CircuitBreakUtils;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigGroup;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigSet;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigSetLocator;
import com.tencent.polaris.plugins.circuitbreaker.common.HalfOpenConfig;
import com.tencent.polaris.plugins.circuitbreaker.common.HalfOpenCounter;
import com.tencent.polaris.plugins.circuitbreaker.common.RuleIdentifier;
import com.tencent.polaris.plugins.circuitbreaker.common.StateMachine;
import com.tencent.polaris.plugins.circuitbreaker.common.stat.SliceWindow;
import com.tencent.polaris.plugins.circuitbreaker.errrate.Config;
import com.tencent.polaris.plugins.circuitbreaker.errrate.Dimension;
import com.tencent.polaris.plugins.circuitbreaker.errrate.ErrRateCounter;
import com.tencent.polaris.plugins.circuitbreaker.errrate.StateMachineImpl;
import java.util.Collection;
import java.util.function.Function;

public class ErrRateCircuitBreaker
extends Destroyable
implements InstanceCircuitBreaker,
PluginConfigProvider,
ConfigSetLocator<Config> {
    private int id;
    private ConfigGroup<Config> configGroup;
    private long metricWindowMs;
    private Extensions extensions;
    private FlowControlParam flowControlParam;
    private StateMachine<Config> stateMachine;
    private LocalRegistry localRegistry;
    private Function<Integer, Object> create;
    private final String metricWindowName = String.format("%s_%s", this.getName(), "metric");
    private CircuitBreakerConfig circuitBreakerConfig;

    public void init(InitContext ctx) throws PolarisException {
        this.circuitBreakerConfig = ctx.getConfig().getConsumer().getCircuitBreaker();
        OutlierDetectionConfig outlierDetection = ctx.getConfig().getConsumer().getOutlierDetection();
        this.metricWindowMs = this.circuitBreakerConfig.getCheckPeriod();
        HalfOpenConfig halfOpenConfig = new HalfOpenConfig(this.circuitBreakerConfig, outlierDetection);
        Config cfg = (Config)this.circuitBreakerConfig.getPluginConfig(this.getName(), Config.class);
        if (cfg == null) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("plugin %s config is missing", this.getName()));
        }
        final ConfigSet configSet = new ConfigSet(StatusDimension.Level.SERVICE, false, halfOpenConfig, (Verifier)cfg);
        this.create = new Function<Integer, Object>(){

            @Override
            public Object apply(Integer integer) {
                return new ErrRateCounter(ErrRateCircuitBreaker.this.metricWindowName, (Config)configSet.getPlugConfig(), ErrRateCircuitBreaker.this.getBucketIntervalMs());
            }
        };
        this.configGroup = new ConfigGroup(configSet);
        this.stateMachine = new StateMachineImpl(this.configGroup, this.id, this, this.metricWindowMs);
        this.flowControlParam = new DefaultFlowControlParam(ctx.getConfig().getGlobal().getAPI());
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
        this.extensions = extensions;
        this.localRegistry = extensions.getLocalRegistry();
    }

    public boolean stat(InstanceGauge gauge) {
        InstanceByProto instance = ChangeStateUtils.getInstance((InstanceGauge)gauge, (LocalRegistry)this.localRegistry);
        if (null == instance) {
            return false;
        }
        InstanceLocalValue instanceLocalValue = instance.getInstanceLocalValue();
        if (null == instanceLocalValue) {
            return false;
        }
        ConfigSet configSet = CircuitBreakUtils.getConfigSet((InstanceGauge)gauge, (ConfigSetLocator)this);
        StatusDimension statusDimension = ChangeStateUtils.buildStatusDimension((InstanceGauge)gauge, (StatusDimension.Level)configSet.getLevel());
        if (CircuitBreakUtils.instanceClose((Instance)instance, (StatusDimension)statusDimension)) {
            Object pluginValue = instanceLocalValue.getPluginValue(this.id, this.create);
            ErrRateCounter errRateCounter = (ErrRateCounter)((Object)pluginValue);
            SliceWindow metricWindow = errRateCounter.getSliceWindow(statusDimension);
            metricWindow.addGauge(bucket -> {
                bucket.addMetric(Dimension.keyRequestCount.ordinal(), 1L);
                if (gauge.getRetStatus() == RetStatus.RetFail) {
                    return bucket.addMetric(Dimension.keyFailCount.ordinal(), 1L);
                }
                return bucket.getMetric(Dimension.keyFailCount.ordinal());
            });
        } else if (CircuitBreakUtils.instanceHalfOpen((Instance)instance, (StatusDimension)statusDimension)) {
            Object pluginValue = instanceLocalValue.getPluginValue(this.id, this.create);
            HalfOpenCounter consecutiveCounter = (HalfOpenCounter)pluginValue;
            RetStatus retStatus = gauge.getRetStatus();
            return consecutiveCounter.triggerHalfOpenConversion(statusDimension, retStatus, configSet.getHalfOpenConfig());
        }
        return false;
    }

    public long getBucketIntervalMs() {
        double bucketIntervalMs = (double)this.metricWindowMs / (double)((Config)this.configGroup.getLocalConfig().getPlugConfig()).getMetricNumBuckets().intValue();
        return (long)Math.ceil(bucketIntervalMs);
    }

    public CircuitBreakResult checkInstance(Collection<Instance> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return null;
        }
        StateMachine.Parameter parameter = new StateMachine.Parameter(this.id, this.getName(), this.configGroup.getLocalConfig().getHalfOpenConfig().getHalfOpenMaxReqCount());
        return ChangeStateUtils.buildCircuitBreakResult(this.stateMachine, instances, (StateMachine.Parameter)parameter);
    }

    public CircuitBreakResult checkSubset(Collection<Subset> subsets) {
        return null;
    }

    public String getName() {
        return "errorRate";
    }

    public Class<? extends Verifier> getPluginConfigClazz() {
        return Config.class;
    }

    public PluginType getType() {
        return PluginTypes.INSTANCE_CIRCUIT_BREAKER.getBaseType();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ConfigSet<Config> getConfigSet(RuleIdentifier ruleIdentifier) {
        return this.configGroup.getServiceConfig(ruleIdentifier, (Function)new Function<RuleIdentifier, ConfigSet<Config>>(){

            @Override
            public ConfigSet<Config> apply(RuleIdentifier ruleIdentifier) {
                return new ConfigSet(StatusDimension.Level.SERVICE, true, null, null);
            }
        });
    }
}

