/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.util.expresstion;

import com.tencent.cloud.common.util.expresstion.ExpressionParser;
import org.apache.commons.lang.StringUtils;

public class ExpressionParserV2
implements ExpressionParser {
    private static final String LABEL_HEADER_PREFIX = "$header.";
    private static final int LABEL_HEADER_PREFIX_LEN = "$header.".length();
    private static final String LABEL_QUERY_PREFIX = "$query.";
    private static final int LABEL_QUERY_PREFIX_LEN = "$query.".length();
    private static final String LABEL_METHOD = "$method";
    private static final String LABEL_PATH = "$path";
    private static final String LABEL_CALLER_IP = "$caller_ip";
    private static final String LABEL_PREFIX = "$";

    @Override
    public boolean isExpressionLabel(String expression) {
        return StringUtils.startsWith((String)expression, (String)LABEL_PREFIX);
    }

    @Override
    public boolean isHeaderLabel(String expression) {
        return StringUtils.startsWith((String)expression, (String)LABEL_HEADER_PREFIX);
    }

    @Override
    public String parseHeaderKey(String expression) {
        return StringUtils.substring((String)expression, (int)LABEL_HEADER_PREFIX_LEN);
    }

    @Override
    public boolean isQueryLabel(String expression) {
        return StringUtils.startsWith((String)expression, (String)LABEL_QUERY_PREFIX);
    }

    @Override
    public String parseQueryKey(String expression) {
        return StringUtils.substring((String)expression, (int)LABEL_QUERY_PREFIX_LEN);
    }

    @Override
    public boolean isCookieLabel(String expression) {
        return false;
    }

    @Override
    public String parseCookieKey(String expression) {
        return null;
    }

    @Override
    public boolean isMethodLabel(String expression) {
        return StringUtils.equalsIgnoreCase((String)expression, (String)LABEL_METHOD);
    }

    @Override
    public boolean isUriLabel(String expression) {
        return StringUtils.equalsIgnoreCase((String)expression, (String)LABEL_PATH);
    }

    @Override
    public boolean isCallerIPLabel(String expression) {
        return StringUtils.equalsIgnoreCase((String)expression, (String)LABEL_CALLER_IP);
    }
}

