/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.common.util;

import java.lang.reflect.Field;
import java.util.Locale;
import org.springframework.util.ClassUtils;

public final class ReflectionUtils
extends org.springframework.util.ReflectionUtils {
    private static final String SET_PREFIX = "set";

    private ReflectionUtils() {
    }

    public static boolean writableBeanField(Field field) {
        String fieldName = field.getName();
        String setMethodName = SET_PREFIX + ReflectionUtils.capitalize(fieldName);
        return ClassUtils.hasMethod(field.getDeclaringClass(), (String)setMethodName, (Class[])new Class[]{field.getType()});
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFieldValue(Object instance, String fieldName) {
        Field field = org.springframework.util.ReflectionUtils.findField(instance.getClass(), (String)fieldName);
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            Object object = field.get(instance);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        finally {
            field.setAccessible(false);
        }
        return null;
    }
}

