/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.spring.property;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;

public class SpringValue {
    private final WeakReference<Object> beanRef;
    private final String beanName;
    private final String key;
    private final String placeholder;
    private final Class<?> targetType;
    private MethodParameter methodParameter;
    private Field field;

    public SpringValue(String key, String placeholder, Object bean, String beanName, Field field) {
        this.beanRef = new WeakReference<Object>(bean);
        this.beanName = beanName;
        this.field = field;
        this.key = key;
        this.placeholder = placeholder;
        this.targetType = field.getType();
    }

    public SpringValue(String key, String placeholder, Object bean, String beanName, Method method) {
        this.beanRef = new WeakReference<Object>(bean);
        this.beanName = beanName;
        this.methodParameter = new MethodParameter(method, 0);
        this.key = key;
        this.placeholder = placeholder;
        Class<?>[] paramTps = method.getParameterTypes();
        this.targetType = paramTps[0];
    }

    public void update(Object newVal) throws IllegalAccessException, InvocationTargetException {
        if (this.isField()) {
            this.injectField(newVal);
        } else {
            this.injectMethod(newVal);
        }
    }

    private void injectField(Object newVal) throws IllegalAccessException {
        Object bean = this.beanRef.get();
        if (bean == null) {
            return;
        }
        boolean accessible = this.field.isAccessible();
        this.field.setAccessible(true);
        this.field.set(bean, newVal);
        this.field.setAccessible(accessible);
    }

    private void injectMethod(Object newVal) throws InvocationTargetException, IllegalAccessException {
        Object bean = this.beanRef.get();
        if (bean == null || this.methodParameter.getMethod() == null) {
            return;
        }
        this.methodParameter.getMethod().invoke(bean, newVal);
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public boolean isField() {
        return this.field != null;
    }

    public Field getField() {
        return this.field;
    }

    boolean isTargetBeanValid() {
        return this.beanRef.get() != null;
    }

    public String toString() {
        Object bean = this.beanRef.get();
        if (bean == null) {
            return "";
        }
        if (this.isField()) {
            return String.format("key: %s, beanName: %s, field: %s.%s", this.key, this.beanName, bean.getClass().getName(), this.field.getName());
        }
        if (null != this.methodParameter.getMethod()) {
            return String.format("key: %s, beanName: %s, method: %s.%s", this.key, this.beanName, bean.getClass().getName(), this.methodParameter.getMethod().getName());
        }
        return String.format("key: %s, beanName: %s", this.key, this.beanName);
    }
}

