/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.adapter;

import com.tencent.cloud.polaris.config.adapter.PolarisConfigFileLocator;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySource;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySourceManager;
import com.tencent.cloud.polaris.config.config.ConfigFileGroup;
import com.tencent.cloud.polaris.config.enums.ConfigFileFormat;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.polaris.configuration.api.core.ConfigFileMetadata;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.api.core.ConfigKVFile;
import com.tencent.polaris.configuration.client.internal.DefaultConfigFileMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class PolarisConfigFilePuller {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisConfigFileLocator.class);
    private PolarisContextProperties polarisContextProperties;
    private ConfigFileService configFileService;
    private PolarisPropertySourceManager polarisPropertySourceManager;

    private PolarisConfigFilePuller() {
    }

    public static PolarisConfigFilePuller get(PolarisContextProperties polarisContextProperties, ConfigFileService configFileService, PolarisPropertySourceManager polarisPropertySourceManager) {
        PolarisConfigFilePuller puller = new PolarisConfigFilePuller();
        puller.polarisContextProperties = polarisContextProperties;
        puller.configFileService = configFileService;
        puller.polarisPropertySourceManager = polarisPropertySourceManager;
        return puller;
    }

    public void initInternalConfigFiles(CompositePropertySource compositePropertySource, String[] activeProfiles, String[] defaultProfiles, String serviceName) {
        List<ConfigFileMetadata> internalConfigFiles = this.getInternalConfigFiles(activeProfiles, defaultProfiles, serviceName);
        for (ConfigFileMetadata configFile : internalConfigFiles) {
            PolarisPropertySource polarisPropertySource = this.loadPolarisPropertySource(configFile.getNamespace(), configFile.getFileGroup(), configFile.getFileName());
            compositePropertySource.addPropertySource((PropertySource)polarisPropertySource);
            this.polarisPropertySourceManager.addPropertySource(polarisPropertySource);
            LOGGER.info("[SCT Config] Load and inject polaris config file. file = {}", (Object)configFile);
        }
    }

    public void initCustomPolarisConfigFiles(CompositePropertySource compositePropertySource, List<ConfigFileGroup> configFileGroups) {
        configFileGroups.forEach(configFileGroup -> this.initCustomPolarisConfigFile(compositePropertySource, (ConfigFileGroup)configFileGroup));
    }

    public void initCustomPolarisConfigFile(CompositePropertySource compositePropertySource, ConfigFileGroup configFileGroup) {
        String namespace = this.polarisContextProperties.getNamespace();
        String group = configFileGroup.getName();
        if (!StringUtils.hasText((String)group)) {
            throw new IllegalArgumentException("polaris config group name cannot be empty.");
        }
        List<String> files = configFileGroup.getFiles();
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        for (String fileName : files) {
            PolarisPropertySource polarisPropertySource = this.loadPolarisPropertySource(namespace, group, fileName);
            compositePropertySource.addPropertySource((PropertySource)polarisPropertySource);
            this.polarisPropertySourceManager.addPropertySource(polarisPropertySource);
            LOGGER.info("[SCT Config] Load and inject polaris config file success. namespace = {}, group = {}, fileName = {}", new Object[]{namespace, group, fileName});
        }
    }

    private PolarisPropertySource loadPolarisPropertySource(String namespace, String group, String fileName) {
        ConfigKVFile configKVFile;
        if (ConfigFileFormat.isPropertyFile(fileName) || ConfigFileFormat.isUnknownFile(fileName)) {
            configKVFile = this.configFileService.getConfigPropertiesFile(namespace, group, fileName);
        } else if (ConfigFileFormat.isYamlFile(fileName)) {
            configKVFile = this.configFileService.getConfigYamlFile(namespace, group, fileName);
        } else {
            LOGGER.warn("[SCT Config] Unsupported config file. namespace = {}, group = {}, fileName = {}", new Object[]{namespace, group, fileName});
            throw new IllegalStateException("Only configuration files in the format of properties / yaml / yaml can be injected into the spring context");
        }
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        for (String key : configKVFile.getPropertyNames()) {
            map.put(key, configKVFile.getProperty(key, null));
        }
        return new PolarisPropertySource(namespace, group, fileName, configKVFile, map);
    }

    private List<ConfigFileMetadata> getInternalConfigFiles(String[] activeProfiles, String[] defaultProfiles, String serviceName) {
        String namespace = this.polarisContextProperties.getNamespace();
        if (StringUtils.hasText((String)this.polarisContextProperties.getService())) {
            serviceName = this.polarisContextProperties.getService();
        }
        return this.getInternalConfigFiles(activeProfiles, defaultProfiles, namespace, serviceName);
    }

    private List<ConfigFileMetadata> getInternalConfigFiles(String[] activeProfiles, String[] defaultProfiles, String namespace, String serviceName) {
        ArrayList<String> profileList = new ArrayList<String>();
        if (ArrayUtils.isNotEmpty((Object[])activeProfiles)) {
            profileList.addAll(Arrays.asList(activeProfiles));
        } else if (ArrayUtils.isNotEmpty((Object[])defaultProfiles)) {
            profileList.addAll(Arrays.asList(defaultProfiles));
        }
        LinkedList<ConfigFileMetadata> internalConfigFiles = new LinkedList<ConfigFileMetadata>();
        this.buildInternalApplicationConfigFiles(internalConfigFiles, namespace, serviceName, profileList);
        this.buildInternalBootstrapConfigFiles(internalConfigFiles, namespace, serviceName, profileList);
        return internalConfigFiles;
    }

    private void buildInternalApplicationConfigFiles(List<ConfigFileMetadata> internalConfigFiles, String namespace, String serviceName, List<String> profiles) {
        for (String profile : profiles) {
            if (!StringUtils.hasText((String)profile)) continue;
            internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "application-" + profile + ".properties"));
            internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "application-" + profile + ".yml"));
        }
        internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "application.properties"));
        internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "application.yml"));
    }

    private void buildInternalBootstrapConfigFiles(List<ConfigFileMetadata> internalConfigFiles, String namespace, String serviceName, List<String> profiles) {
        for (String profile : profiles) {
            if (!StringUtils.hasText((String)profile)) continue;
            internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "bootstrap-" + profile + ".properties"));
            internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "bootstrap-" + profile + ".yml"));
        }
        internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "bootstrap.properties"));
        internalConfigFiles.add((ConfigFileMetadata)new DefaultConfigFileMetadata(namespace, serviceName, "bootstrap.yml"));
    }
}

