/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config.adapter;

import com.tencent.cloud.polaris.config.adapter.PolarisConfigFilePuller;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySourceManager;
import com.tencent.cloud.polaris.config.config.ConfigFileGroup;
import com.tencent.cloud.polaris.config.config.PolarisConfigProperties;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import java.util.List;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

@Order(value=0)
public class PolarisConfigFileLocator
implements PropertySourceLocator {
    private static final String POLARIS_CONFIG_PROPERTY_SOURCE_NAME = "polaris-config";
    private final PolarisConfigProperties polarisConfigProperties;
    private final PolarisConfigFilePuller polarisConfigFilePuller;

    public PolarisConfigFileLocator(PolarisConfigProperties polarisConfigProperties, PolarisContextProperties polarisContextProperties, ConfigFileService configFileService, PolarisPropertySourceManager polarisPropertySourceManager, Environment environment) {
        this.polarisConfigProperties = polarisConfigProperties;
        this.polarisConfigFilePuller = PolarisConfigFilePuller.get(polarisContextProperties, configFileService, polarisPropertySourceManager);
    }

    public PropertySource<?> locate(Environment environment) {
        CompositePropertySource compositePropertySource = new CompositePropertySource(POLARIS_CONFIG_PROPERTY_SOURCE_NAME);
        String[] activeProfiles = environment.getActiveProfiles();
        String[] defaultProfiles = environment.getDefaultProfiles();
        String serviceName = environment.getProperty("spring.application.name");
        this.polarisConfigFilePuller.initInternalConfigFiles(compositePropertySource, activeProfiles, defaultProfiles, serviceName);
        List<ConfigFileGroup> configFileGroups = this.polarisConfigProperties.getGroups();
        if (CollectionUtils.isEmpty(configFileGroups)) {
            return compositePropertySource;
        }
        this.polarisConfigFilePuller.initCustomPolarisConfigFiles(compositePropertySource, configFileGroups);
        return compositePropertySource;
    }
}

