/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config;

import com.tencent.cloud.polaris.config.ConditionalOnConnectRemoteServerEnabled;
import com.tencent.cloud.polaris.config.ConditionalOnPolarisConfigEnabled;
import com.tencent.cloud.polaris.config.ConfigurationModifier;
import com.tencent.cloud.polaris.config.adapter.AffectedConfigurationPropertiesRebinder;
import com.tencent.cloud.polaris.config.adapter.PolarisConfigFileLocator;
import com.tencent.cloud.polaris.config.adapter.PolarisPropertySourceManager;
import com.tencent.cloud.polaris.config.condition.ConditionalOnReflectRefreshType;
import com.tencent.cloud.polaris.config.config.PolarisConfigProperties;
import com.tencent.cloud.polaris.context.config.PolarisContextAutoConfiguration;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import com.tencent.polaris.configuration.factory.ConfigFileServiceFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.cloud.context.properties.ConfigurationPropertiesBeans;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnPolarisConfigEnabled
@Import(value={PolarisContextAutoConfiguration.class})
public class PolarisConfigBootstrapAutoConfiguration {
    @Bean
    public PolarisConfigProperties polarisProperties() {
        return new PolarisConfigProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public PolarisPropertySourceManager polarisPropertySourceManager() {
        return new PolarisPropertySourceManager();
    }

    @Bean
    @ConditionalOnConnectRemoteServerEnabled
    public ConfigFileService configFileService(SDKContext sdkContext) {
        return ConfigFileServiceFactory.createConfigFileService((SDKContext)sdkContext);
    }

    @Bean
    @ConditionalOnConnectRemoteServerEnabled
    public PolarisConfigFileLocator polarisConfigFileLocator(PolarisConfigProperties polarisConfigProperties, PolarisContextProperties polarisContextProperties, ConfigFileService configFileService, PolarisPropertySourceManager polarisPropertySourceManager, Environment environment) {
        return new PolarisConfigFileLocator(polarisConfigProperties, polarisContextProperties, configFileService, polarisPropertySourceManager, environment);
    }

    @Bean
    @ConditionalOnConnectRemoteServerEnabled
    public ConfigurationModifier configurationModifier(PolarisConfigProperties polarisConfigProperties, PolarisContextProperties polarisContextProperties) {
        return new ConfigurationModifier(polarisConfigProperties, polarisContextProperties);
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    @ConditionalOnReflectRefreshType
    public ConfigurationPropertiesRebinder affectedConfigurationPropertiesRebinder(ConfigurationPropertiesBeans beans) {
        return new AffectedConfigurationPropertiesRebinder(beans);
    }
}

