/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.polaris.config;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.util.AddressUtils;
import com.tencent.cloud.polaris.config.config.PolarisConfigProperties;
import com.tencent.cloud.polaris.context.PolarisConfigModifier;
import com.tencent.cloud.polaris.context.config.PolarisContextProperties;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ConfigurationModifier
implements PolarisConfigModifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationModifier.class);
    private static final String DATA_SOURCE_POLARIS = "polaris";
    private static final String DATA_SOURCE_LOCAL = "local";
    private final PolarisConfigProperties polarisConfigProperties;
    private final PolarisContextProperties polarisContextProperties;

    public ConfigurationModifier(PolarisConfigProperties polarisConfigProperties, PolarisContextProperties polarisContextProperties) {
        this.polarisConfigProperties = polarisConfigProperties;
        this.polarisContextProperties = polarisContextProperties;
    }

    public void modify(ConfigurationImpl configuration) {
        if (StringUtils.equalsIgnoreCase((String)this.polarisConfigProperties.getDataSource(), (String)DATA_SOURCE_POLARIS)) {
            this.initByPolarisDataSource(configuration);
        } else if (StringUtils.equalsIgnoreCase((String)this.polarisConfigProperties.getDataSource(), (String)DATA_SOURCE_LOCAL)) {
            this.initByLocalDataSource(configuration);
        } else {
            throw new RuntimeException("Unsupported config data source");
        }
    }

    private void initByLocalDataSource(ConfigurationImpl configuration) {
        configuration.getConfigFile().getServerConnector().setConnectorType("localFile");
        String localFileRootPath = this.polarisConfigProperties.getLocalFileRootPath();
        configuration.getConfigFile().getServerConnector().setPersistDir(localFileRootPath);
        LOGGER.info("[SCT] Run spring cloud tencent config with local data source. localFileRootPath = {}", (Object)localFileRootPath);
    }

    private void initByPolarisDataSource(ConfigurationImpl configuration) {
        configuration.getConfigFile().getServerConnector().setConnectorType(DATA_SOURCE_POLARIS);
        String configAddressesStr = this.polarisConfigProperties.getAddress();
        List<String> configAddresses = StringUtils.isNotEmpty((String)configAddressesStr) ? AddressUtils.parseAddressList((String)this.polarisConfigProperties.getAddress()) : this.resolveConfigAddressFromPolarisAddress(this.polarisContextProperties.getAddress());
        if (CollectionUtils.isEmpty(configAddresses)) {
            throw new RuntimeException("Config server address is blank. Please check your config in bootstrap.yml with spring.cloud.polaris.address or spring.cloud.polaris.config.address");
        }
        this.checkAddressAccessible(configAddresses);
        configuration.getConfigFile().getServerConnector().setAddresses(configAddresses);
        LOGGER.info("[SCT] Run spring cloud tencent config in polaris data source.");
    }

    public int getOrder() {
        return ContextConstant.ModifierOrder.CONFIG_ORDER;
    }

    private List<String> resolveConfigAddressFromPolarisAddress(String polarisAddress) {
        if (StringUtils.isEmpty((String)polarisAddress)) {
            return null;
        }
        List polarisAddresses = AddressUtils.parseAddressList((String)polarisAddress);
        ArrayList<String> configAddresses = new ArrayList<String>(polarisAddresses.size());
        for (String address : polarisAddresses) {
            String ip = StringUtils.substringBeforeLast((String)address, (String)":");
            configAddresses.add(ip + ":" + this.polarisConfigProperties.getPort());
        }
        return configAddresses;
    }

    private void checkAddressAccessible(List<String> configAddresses) {
        configAddresses.forEach(address -> {
            String[] ipPort = address.split(":");
            if (ipPort.length != 2) {
                throw new IllegalArgumentException("Config server address (" + address + ") is wrong, please check address like grpc://183.47.111.8:8091.");
            }
            if (!AddressUtils.accessible((String)ipPort[0], (int)Integer.parseInt(ipPort[1]), (int)3000)) {
                String errMsg = "Config server address (" + address + ") can not be connected. Please check your config in bootstrap.yml with spring.cloud.polaris.address or spring.cloud.polaris.config.address.";
                if (this.polarisConfigProperties.isShutdownIfConnectToConfigServerFailed()) {
                    throw new IllegalArgumentException(errMsg);
                }
                LOGGER.error(errMsg);
            }
        });
    }
}

