/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.AbstractDriver;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.RestfulConnection;
import com.taosdata.jdbc.utils.HttpClientPoolUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;

public class RestfulDriver
extends AbstractDriver {
    private static final String URL_PREFIX = "jdbc:TAOS-RS://";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String token;
        if (url == null || url.trim().isEmpty() || url.trim().replaceAll("\\s", "").isEmpty()) {
            throw TSDBError.createSQLException(8978);
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties props = this.parseURL(url, info);
        String host = props.getProperty("host");
        String port = props.getProperty("port", "6041");
        String database = props.containsKey("dbname") ? props.getProperty("dbname") : null;
        String loginUrl = "http://" + props.getProperty("host") + ":" + props.getProperty("port") + "/rest/login/" + props.getProperty("user") + "/" + props.getProperty("password") + "";
        try {
            String user = URLEncoder.encode(props.getProperty("user"), "UTF-8");
            String password = URLEncoder.encode(props.getProperty("password"), "UTF-8");
            loginUrl = "http://" + props.getProperty("host") + ":" + props.getProperty("port") + "/rest/login/" + user + "/" + password + "";
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String result = HttpClientPoolUtil.execute(loginUrl);
        JSONObject jsonResult = JSON.parseObject((String)result);
        String status = jsonResult.getString("status");
        HttpClientPoolUtil.token = token = jsonResult.getString("desc");
        if (!status.equals("succ")) {
            throw new SQLException(jsonResult.getString("desc"));
        }
        RestfulConnection conn = new RestfulConnection(host, port, props, database, url);
        if (database != null && !database.trim().replaceAll("\\s", "").isEmpty()) {
            Statement stmt = conn.createStatement();
            stmt.execute("use " + database);
            stmt.close();
        }
        return conn;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw TSDBError.createSQLException(8978);
        }
        return url.length() > 0 && url.trim().length() > 0 && url.startsWith(URL_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (info == null) {
            info = new Properties();
        }
        if (this.acceptsURL(url)) {
            info = this.parseURL(url, info);
        }
        return this.getPropertyInfo(info);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new RestfulDriver());
        }
        catch (SQLException e) {
            throw TSDBError.createRuntimeException(8978, e);
        }
    }
}

