/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractResultSet;
import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBResultSetBlockData;
import com.taosdata.jdbc.TSDBResultSetMetaData;
import com.taosdata.jdbc.TSDBResultSetRowData;
import com.taosdata.jdbc.TSDBStatement;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class TSDBResultSet
extends AbstractResultSet
implements ResultSet {
    private final TSDBJNIConnector jniConnector;
    private final TSDBStatement statement;
    private final long resultSetPointer;
    private List<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
    private final TSDBResultSetRowData rowData;
    private final TSDBResultSetBlockData blockData;
    private boolean batchFetch;
    private boolean lastWasNull;
    private boolean isClosed;

    public void setBatchFetch(boolean batchFetch) {
        this.batchFetch = batchFetch;
    }

    public Boolean getBatchFetch() {
        return this.batchFetch;
    }

    public void setColumnMetaDataList(List<ColumnMetaData> columnMetaDataList) {
        this.columnMetaDataList = columnMetaDataList;
    }

    public TSDBResultSetRowData getRowData() {
        return this.rowData;
    }

    public TSDBResultSet(TSDBStatement statement, TSDBJNIConnector connector, long resultSetPointer) throws SQLException {
        this.statement = statement;
        this.jniConnector = connector;
        this.resultSetPointer = resultSetPointer;
        int code = this.jniConnector.getSchemaMetaData(this.resultSetPointer, this.columnMetaDataList);
        if (code == -2) {
            throw TSDBError.createSQLException(9044);
        }
        if (code == -3) {
            throw TSDBError.createSQLException(9045);
        }
        if (code == -4) {
            throw TSDBError.createSQLException(9046);
        }
        this.rowData = new TSDBResultSetRowData(this.columnMetaDataList.size());
        this.blockData = new TSDBResultSetBlockData(this.columnMetaDataList, this.columnMetaDataList.size());
    }

    @Override
    public boolean next() throws SQLException {
        int code;
        if (this.getBatchFetch().booleanValue()) {
            if (this.blockData.forward()) {
                return true;
            }
            int code2 = this.jniConnector.fetchBlock(this.resultSetPointer, this.blockData);
            this.blockData.reset();
            if (code2 == -2) {
                throw TSDBError.createSQLException(9044);
            }
            if (code2 == -3) {
                throw TSDBError.createSQLException(9045);
            }
            if (code2 == -4) {
                throw TSDBError.createSQLException(9046);
            }
            return code2 != -6;
        }
        if (this.rowData != null) {
            this.rowData.clear();
        }
        if ((code = this.jniConnector.fetchRow(this.resultSetPointer, this.rowData)) == -2) {
            throw TSDBError.createSQLException(9044);
        }
        if (code == -3) {
            throw TSDBError.createSQLException(9045);
        }
        if (code == -4) {
            throw TSDBError.createSQLException(9046);
        }
        return code != -6;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.jniConnector != null) {
            int code = this.jniConnector.freeResultSet(this.resultSetPointer);
            if (code == -2) {
                throw TSDBError.createSQLException(9044);
            }
            if (code == -3) {
                throw TSDBError.createSQLException(9045);
            }
        }
        this.isClosed = true;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastWasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String res = null;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (this.getBatchFetch().booleanValue()) {
            return this.blockData.getString(colIndex);
        }
        this.lastWasNull = this.rowData.wasNull(colIndex);
        if (!this.lastWasNull) {
            res = this.rowData.getString(colIndex, this.columnMetaDataList.get(colIndex).getColType());
        }
        return res;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        boolean res = false;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (this.getBatchFetch().booleanValue()) {
            return this.blockData.getBoolean(colIndex);
        }
        this.lastWasNull = this.rowData.wasNull(colIndex);
        if (!this.lastWasNull) {
            res = this.rowData.getBoolean(colIndex, this.columnMetaDataList.get(colIndex).getColType());
        }
        return res;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        byte res = 0;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (this.getBatchFetch().booleanValue()) {
            return (byte)this.blockData.getInt(colIndex);
        }
        this.lastWasNull = this.rowData.wasNull(colIndex);
        if (!this.lastWasNull) {
            res = (byte)this.rowData.getInt(colIndex, this.columnMetaDataList.get(colIndex).getColType());
        }
        return res;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        short res = 0;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (this.getBatchFetch().booleanValue()) {
            return (short)this.blockData.getInt(colIndex);
        }
        this.lastWasNull = this.rowData.wasNull(colIndex);
        if (!this.lastWasNull) {
            res = (short)this.rowData.getInt(colIndex, this.columnMetaDataList.get(colIndex).getColType());
        }
        return res;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int res = 0;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (this.getBatchFetch().booleanValue()) {
            return this.blockData.getInt(colIndex);
        }
        this.lastWasNull = this.rowData.wasNull(colIndex);
        if (!this.lastWasNull) {
            res = this.rowData.getInt(colIndex, this.columnMetaDataList.get(colIndex).getColType());
        }
        return res;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        long res = 0L;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (this.getBatchFetch().booleanValue()) {
            return this.blockData.getLong(colIndex);
        }
        this.lastWasNull = this.rowData.wasNull(colIndex);
        if (!this.lastWasNull) {
            res = this.rowData.getLong(colIndex, this.columnMetaDataList.get(colIndex).getColType());
        }
        return res;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        float res = 0.0f;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (this.getBatchFetch().booleanValue()) {
            return (float)this.blockData.getDouble(colIndex);
        }
        this.lastWasNull = this.rowData.wasNull(colIndex);
        if (!this.lastWasNull) {
            res = this.rowData.getFloat(colIndex, this.columnMetaDataList.get(colIndex).getColType());
        }
        return res;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        double res = 0.0;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (this.getBatchFetch().booleanValue()) {
            return this.blockData.getDouble(colIndex);
        }
        this.lastWasNull = this.rowData.wasNull(colIndex);
        if (!this.lastWasNull) {
            res = this.rowData.getDouble(colIndex, this.columnMetaDataList.get(colIndex).getColType());
        }
        return res;
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return new BigDecimal(this.getLong(columnIndex));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getString(columnIndex).getBytes();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp res = null;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (this.getBatchFetch().booleanValue()) {
            return this.blockData.getTimestamp(columnIndex);
        }
        this.lastWasNull = this.rowData.wasNull(colIndex);
        if (!this.lastWasNull) {
            res = this.rowData.getTimestamp(colIndex);
        }
        return res;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new TSDBResultSetMetaData(this.columnMetaDataList);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (this.getBatchFetch().booleanValue()) {
            return this.blockData.get(colIndex);
        }
        this.lastWasNull = this.rowData.wasNull(colIndex);
        return this.rowData.get(colIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        for (ColumnMetaData colMetaData : this.columnMetaDataList) {
            if (colMetaData.getColName() == null || !colMetaData.getColName().equalsIgnoreCase(columnLabel)) continue;
            return colMetaData.getColIndex() + 1;
        }
        throw TSDBError.createSQLException(8963);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            return new BigDecimal(this.rowData.getLong(colIndex, this.columnMetaDataList.get(colIndex).getColType()));
        }
        return new BigDecimal(this.blockData.getLong(colIndex));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean first() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean last() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public int getRow() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        throw TSDBError.createSQLException(8962);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8965);
        }
        return this.statement;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        if (this.jniConnector != null) {
            this.isClosed = this.jniConnector.isResultsetClosed();
        }
        return this.isClosed;
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        int colIndex = this.getTrueColumnIndex(columnIndex);
        return (String)this.rowData.get(colIndex);
    }

    private int getTrueColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < 1) {
            throw TSDBError.createSQLException(8973, "columnIndex(" + columnIndex + "): < 1");
        }
        int numOfCols = this.columnMetaDataList.size();
        if (columnIndex > numOfCols) {
            throw TSDBError.createSQLException(8973, "columnIndex: " + columnIndex);
        }
        return columnIndex - 1;
    }
}

