/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBPreparedStatement;
import com.taosdata.jdbc.bean.TSDBPreparedParam;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SavedPreparedStatement {
    private TSDBPreparedStatement tsdbPreparedStatement;
    private List<TSDBPreparedParam> sqlParamList;
    private TSDBPreparedParam initPreparedParam;
    private boolean isTableNameDynamic;
    private Pattern sqlPattern = Pattern.compile("(?s)(?i)^\\s*(INSERT|IMPORT)\\s+INTO\\s+((?<tablename>\\S+)\\s*(\\(.*\\))?\\s+(USING\\s+(?<stableName>\\S+)\\s+TAGS\\s*\\((?<tagValue>.+)\\))?)\\s*VALUES\\s*(?<valueList>\\(.*\\)).*");
    private String sql;
    private String prefix;
    private String middle;
    private int middleParamSize;
    private String valueList;
    private int valueListSize;
    private static final String DEFAULT_VALUE = "NULL";
    private static final String PLACEHOLDER = "?";
    private String tableName;
    private boolean isAddBatch;

    public SavedPreparedStatement(String sql, TSDBPreparedStatement tsdbPreparedStatement) throws SQLException {
        this.sql = sql;
        this.tsdbPreparedStatement = tsdbPreparedStatement;
        this.sqlParamList = new ArrayList<TSDBPreparedParam>();
        this.parsePreparedParam(this.sql);
    }

    private void parsePreparedParam(String sql) throws SQLException {
        Matcher matcher = this.sqlPattern.matcher(sql);
        if (matcher.find()) {
            this.tableName = matcher.group("tablename");
            if (this.tableName != null && PLACEHOLDER.equals(this.tableName)) {
                this.isTableNameDynamic = true;
            }
            this.prefix = matcher.group(1);
            this.middle = matcher.group(2);
            this.valueList = matcher.group("valueList");
            if (this.middle != null && !"".equals(this.middle)) {
                this.middleParamSize = this.parsePlaceholder(this.middle);
            }
            if (this.valueList != null && !"".equals(this.valueList)) {
                this.valueListSize = this.parsePlaceholder(this.valueList);
            }
        } else {
            throw TSDBError.createSQLException(8979);
        }
        this.initPreparedParam = this.initDefaultParam(this.tableName, this.middleParamSize, this.valueListSize);
    }

    private TSDBPreparedParam initDefaultParam(String tableName, int middleParamSize, int valueListSize) {
        TSDBPreparedParam tsdbPreparedParam = new TSDBPreparedParam(tableName);
        tsdbPreparedParam.setMiddleParamList(this.getDefaultParamList(middleParamSize));
        tsdbPreparedParam.setValueList(this.getDefaultParamList(valueListSize));
        return tsdbPreparedParam;
    }

    private List<Object> getDefaultParamList(int paramSize) {
        ArrayList<Object> paramList = new ArrayList<Object>(paramSize);
        if (paramSize > 0) {
            for (int i = 0; i < paramSize; ++i) {
                paramList.add(i, DEFAULT_VALUE);
            }
        }
        return paramList;
    }

    private int parsePlaceholder(String value) {
        Pattern pattern = Pattern.compile("[?]");
        Matcher matcher = pattern.matcher(value);
        int result = 0;
        while (matcher.find()) {
            ++result;
        }
        return result;
    }

    public void setParam(int parameterIndex, Object x) throws SQLException {
        int paramSize = this.middleParamSize + this.valueListSize;
        String errorMsg = String.format("the parameterIndex %s out of the range [1, %s]", parameterIndex, paramSize);
        if (parameterIndex < 1 || parameterIndex > paramSize) {
            throw TSDBError.createSQLException(8973, errorMsg);
        }
        this.isAddBatch = false;
        if (x == null) {
            x = DEFAULT_VALUE;
        }
        if (this.middleParamSize > 0 && --parameterIndex >= 0 && parameterIndex < this.middleParamSize) {
            this.initPreparedParam.setMiddleParam(parameterIndex, x);
            return;
        }
        if (this.valueListSize > 0 && parameterIndex >= this.middleParamSize && parameterIndex < paramSize) {
            this.initPreparedParam.setValueParam(parameterIndex - this.middleParamSize, x);
            return;
        }
        throw TSDBError.createSQLException(8973, errorMsg);
    }

    public void addBatch() {
        this.addCurrentRowParamToList();
        this.initPreparedParam = this.initDefaultParam(this.tableName, this.middleParamSize, this.valueListSize);
    }

    private void addCurrentRowParamToList() {
        if (this.initPreparedParam != null && (this.middleParamSize > 0 || this.valueListSize > 0)) {
            this.sqlParamList.add(this.initPreparedParam);
        }
        this.isAddBatch = true;
    }

    public int[] executeBatch() throws SQLException {
        int result = this.executeBatchInternal();
        return new int[]{result};
    }

    public int executeBatchInternal() throws SQLException {
        if (!this.isAddBatch) {
            this.addCurrentRowParamToList();
        }
        String sql = this.generateExecuteSql();
        int result = this.executeSql(sql);
        this.sqlParamList.clear();
        return result;
    }

    private String generateExecuteSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.prefix);
        stringBuilder.append(" into ");
        if (!this.isTableNameDynamic) {
            String middleValue = this.replaceMiddleListParam(this.middle, this.sqlParamList);
            stringBuilder.append(middleValue);
            stringBuilder.append(" values");
            stringBuilder.append(this.replaceValueListParam(this.valueList, this.sqlParamList));
        } else if (this.sqlParamList.size() > 0) {
            TSDBPreparedParam firstPreparedParam = this.sqlParamList.get(0);
            String firstRow = this.replaceMiddleAndValuePart(firstPreparedParam);
            stringBuilder.append(firstRow);
            String lastTableName = firstPreparedParam.getMiddleParamList().get(0).toString();
            if (this.sqlParamList.size() > 1) {
                for (int i = 1; i < this.sqlParamList.size(); ++i) {
                    TSDBPreparedParam currentParam = this.sqlParamList.get(i);
                    String currentTableName = currentParam.getMiddleParamList().get(0).toString();
                    if (lastTableName.equalsIgnoreCase(currentTableName)) {
                        String values = this.replaceTemplateParam(this.valueList, currentParam.getValueList());
                        stringBuilder.append(values);
                        continue;
                    }
                    String row = this.replaceMiddleAndValuePart(currentParam);
                    stringBuilder.append(row);
                    lastTableName = currentTableName;
                }
            }
        } else {
            stringBuilder.append(this.middle);
            stringBuilder.append(" values");
            stringBuilder.append(this.valueList);
        }
        return stringBuilder.toString();
    }

    private String replaceMiddleAndValuePart(TSDBPreparedParam tsdbPreparedParam) {
        StringBuilder stringBuilder = new StringBuilder(" ");
        String middlePart = this.replaceTemplateParam(this.middle, tsdbPreparedParam.getMiddleParamList());
        stringBuilder.append(middlePart);
        stringBuilder.append(" values ");
        String valuePart = this.replaceTemplateParam(this.valueList, tsdbPreparedParam.getValueList());
        stringBuilder.append(valuePart);
        stringBuilder.append(" ");
        return stringBuilder.toString();
    }

    private String replaceMiddleListParam(String template, List<TSDBPreparedParam> sqlParamList) {
        if (sqlParamList.size() > 0) {
            return this.replaceTemplateParam(template, sqlParamList.get(0).getMiddleParamList());
        }
        return template;
    }

    private String replaceValueListParam(String template, List<TSDBPreparedParam> sqlParamList) {
        StringBuilder stringBuilder = new StringBuilder();
        if (sqlParamList.size() > 0) {
            for (TSDBPreparedParam tsdbPreparedParam : sqlParamList) {
                String tmp = this.replaceTemplateParam(template, tsdbPreparedParam.getValueList());
                stringBuilder.append(tmp);
            }
        } else {
            stringBuilder.append(template);
        }
        return stringBuilder.toString();
    }

    private String replaceTemplateParam(String template, List<Object> paramList) {
        if (paramList.size() > 0) {
            String tmp = template;
            for (int i = 0; i < paramList.size(); ++i) {
                String paraStr = this.getParamString(paramList.get(i));
                tmp = tmp.replaceFirst("[?]", paraStr);
            }
            return tmp;
        }
        return template;
    }

    private String getParamString(Object paramObj) {
        String paraStr = paramObj.toString();
        if (paramObj instanceof Timestamp || paramObj instanceof String && !DEFAULT_VALUE.equalsIgnoreCase(paraStr)) {
            paraStr = "'" + paraStr + "'";
        }
        return paraStr;
    }

    private int executeSql(String sql) throws SQLException {
        return this.tsdbPreparedStatement.executeUpdate(sql);
    }
}

