/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.extension.wsdl11.mime;

import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLExtension;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAP11Constants;
import org.jvnet.wom.api.binding.wsdl11.soap.SOAPBody;
import org.jvnet.wom.impl.extension.Messages;
import org.jvnet.wom.impl.extension.wsdl11.AbstractWSDLExtensionHandler;
import org.jvnet.wom.impl.extension.wsdl11.mime.MimeContentImpl;
import org.jvnet.wom.impl.extension.wsdl11.mime.MimeMultipartImpl;
import org.jvnet.wom.impl.extension.wsdl11.mime.MimePartImpl;
import org.jvnet.wom.impl.extension.wsdl11.soap.SOAPBodyImpl;
import org.jvnet.wom.impl.util.XmlUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeMultipartParser
extends AbstractWSDLExtensionHandler {
    private final QName[] names = new QName[]{new QName("http://schemas.xmlsoap.org/wsdl/mime/", "multipartRelatedType")};
    private final ContentHandler contentHandler = new MimeMultipartContentHandler();
    private MimeMultipartImpl multipartImpl;

    public MimeMultipartParser(ErrorHandler errorHandler, EntityResolver entityResolver) {
        super(errorHandler, entityResolver);
    }

    @Override
    protected QName[] getExtensionNames() {
        return this.names;
    }

    @Override
    public Collection<WSDLExtension> getExtensions() {
        return Collections.singleton(this.multipartImpl);
    }

    @Override
    public ContentHandler getContentHandlerFor(String nsUri, String localName) {
        if ("http://schemas.xmlsoap.org/wsdl/mime/".equals(nsUri) && localName.equals("multipartRelated")) {
            return this.contentHandler;
        }
        return null;
    }

    private class MimeMultipartContentHandler
    extends AbstractWSDLExtensionHandler.WSDLExtensibilityContentHandler {
        int mimePartState = 0;
        MimePartImpl mimePart = null;

        private MimeMultipartContentHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("http://schemas.xmlsoap.org/wsdl/mime/".equals(uri) && localName.equals("multipartRelated")) {
                MimeMultipartParser.this.multipartImpl = new MimeMultipartImpl();
            } else if ("http://schemas.xmlsoap.org/wsdl/mime/".equals(uri) && localName.equals("part")) {
                this.mimePart = new MimePartImpl(XmlUtil.fixNull(atts.getValue("name")), this.locator);
                MimeMultipartParser.this.multipartImpl.addMimePart(this.mimePart);
            } else if ("http://schemas.xmlsoap.org/wsdl/mime/".equals(uri) && localName.equals("content")) {
                String part = XmlUtil.fixNull(atts.getValue("part"));
                String type = atts.getValue("type");
                if (type != null && this.mimePart != null) {
                    this.mimePart.addMimeContent(new MimeContentImpl(part, type, this.locator));
                }
            } else if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(uri) && localName.equals("body")) {
                String encodingStyleAtt = atts.getValue("encodingStyle");
                String[] encodingStyle = null;
                if (encodingStyleAtt != null) {
                    encodingStyle = encodingStyleAtt.split("\\s");
                }
                String namespace = atts.getValue("namespace");
                String useatt = XmlUtil.fixNull(atts.getValue("use")).trim();
                SOAPBody.Use use = SOAPBody.Use.literal;
                if (useatt.equals("encoded")) {
                    use = SOAPBody.Use.encoded;
                } else if (!useatt.equals("literal")) {
                    MimeMultipartParser.this.errorHandler.error(new SAXParseException(Messages.format("invalid.attr", "use", useatt, "literal or encoded"), this.locator));
                }
                String partsAtt = atts.getValue("parts");
                String[] parts = null;
                if (partsAtt != null) {
                    parts = partsAtt.split("\\s");
                }
                SOAPBodyImpl body = new SOAPBodyImpl(SOAP11Constants.SOAPBODY_NAME);
                body = new SOAPBodyImpl(new QName(uri, localName));
                body.setParts(parts);
                body.setEncodingStyle(encodingStyle);
                body.setNamespace(namespace);
                body.setUse(use);
                if (this.mimePart != null) {
                    this.mimePart.setBodyPart(body);
                }
            }
        }
    }
}

