/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.wom.api.WSDLDefinitions;
import org.jvnet.wom.api.WSDLExtensible;
import org.jvnet.wom.api.WSDLExtension;
import org.jvnet.wom.api.WSDLVisitor;
import org.jvnet.wom.api.parser.WSDLDocument;
import org.jvnet.wom.impl.parser.WSDLDocumentImpl;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSDLEntity
implements WSDLExtensible {
    private WSDLDocumentImpl ownerDoc;
    private final Set<WSDLExtension> extensions = new HashSet<WSDLExtension>();
    private final Locator locator;
    private final QName name;
    private Map<Class<? extends WSDLExtension>, List<WSDLExtension>> extensionMap = new HashMap<Class<? extends WSDLExtension>, List<WSDLExtension>>();

    protected WSDLEntity(Locator locator, QName name) {
        this.locator = locator;
        this.name = name;
    }

    public QName getName() {
        return this.name;
    }

    public Locator getLocation() {
        return this.locator;
    }

    public WSDLDefinitions getOwnerWSDLModel() {
        return this.ownerDoc.getWSDLModel();
    }

    public WSDLDocument getWSDLDocument() {
        return this.ownerDoc;
    }

    public String getDocumentation() {
        return "";
    }

    public abstract <V, P> V visit(WSDLVisitor<V, P> var1, P var2);

    @Override
    public final Iterable<WSDLExtension> getExtensions() {
        return this.extensions;
    }

    @Override
    public <T extends WSDLExtension> Collection<T> getExtension(Class<T> type) {
        ArrayList<WSDLExtension> exts = new ArrayList<WSDLExtension>();
        for (WSDLExtension ext : this.extensions) {
            if (!type.isInstance(ext)) continue;
            exts.add(ext);
        }
        return exts;
    }

    public <T extends WSDLExtension> T getFirstExtension(Class<T> type) {
        for (WSDLExtension ext : this.extensions) {
            if (!type.isInstance(ext)) continue;
            return (T)ext;
        }
        return null;
    }

    @Override
    public void addExtension(Collection<WSDLExtension> extension) {
        if (extension != null) {
            this.extensions.addAll(extension);
        }
    }

    protected void setOwnerWSDLDocument(WSDLDocumentImpl wsdlDocument) {
        this.ownerDoc = wsdlDocument;
    }
}

