/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.outgoing;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.enc.JAXBEncryptedData;
import com.sun.xml.ws.security.opt.impl.enc.JAXBEncryptedKey;
import com.sun.xml.ws.security.opt.impl.message.GSHeaderElement;
import com.sun.xml.ws.security.opt.impl.tokens.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityHeader {
    public static final int LAYOUT_LAX = 0;
    public static final int LAYOUT_STRICT = 1;
    public static final int LAYOUT_LAX_TS_FIRST = 2;
    public static final int LAYOUT_LAX_TS_LAST = 3;
    protected ArrayList<SecurityHeaderElement> secHeaderContent = new ArrayList();
    protected int headerLayout = 1;
    protected String soapVersion = "http://schemas.xmlsoap.org/soap/envelope/";
    private boolean debug = false;
    private boolean mustUnderstandValue = true;

    public SecurityHeader() {
    }

    public SecurityHeader(int layout, String soapVersion, boolean muValue) {
        this.headerLayout = layout;
        this.soapVersion = soapVersion;
        this.mustUnderstandValue = muValue;
    }

    public int getHeaderLayout() {
        return this.headerLayout;
    }

    public void setHeaderLayout(int headerLayout) {
        this.headerLayout = headerLayout;
    }

    public String getSOAPVersion() {
        return this.soapVersion;
    }

    public void setSOAPVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public SecurityHeaderElement getChildElement(String localName, String uri) {
        for (SecurityHeaderElement she : this.secHeaderContent) {
            if (!localName.equals(she.getLocalPart()) || !uri.equals(she.getNamespaceURI())) continue;
            return she;
        }
        return null;
    }

    public Iterator getHeaders(final String localName, final String uri) {
        return new Iterator(){
            int idx = 0;
            Object next;

            public boolean hasNext() {
                if (this.next == null) {
                    this.fetch();
                }
                return this.next != null;
            }

            public Object next() {
                if (this.next == null) {
                    this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                Object r = this.next;
                this.next = null;
                return r;
            }

            private void fetch() {
                while (this.idx < SecurityHeader.this.secHeaderContent.size()) {
                    SecurityHeaderElement she = SecurityHeader.this.secHeaderContent.get(this.idx++);
                    if ((uri != null || !localName.equals(she.getLocalPart())) && (!localName.equals(she.getLocalPart()) || !uri.equals(she.getNamespaceURI()))) continue;
                    this.next = she;
                    break;
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public SecurityHeaderElement getChildElement(String id) {
        for (SecurityHeaderElement she : this.secHeaderContent) {
            if (!id.equals(she.getId())) continue;
            return she;
        }
        return null;
    }

    public void add(SecurityHeaderElement header) {
        this.prepend(header);
    }

    public boolean replace(SecurityHeaderElement replaceThis, SecurityHeaderElement withThis) {
        int index = this.secHeaderContent.indexOf(replaceThis);
        if (index != -1) {
            this.secHeaderContent.set(index, withThis);
            return true;
        }
        return false;
    }

    public void prepend(SecurityHeaderElement element) {
        this.secHeaderContent.add(0, element);
    }

    public void append(SecurityHeaderElement element) {
        this.secHeaderContent.add(element);
    }

    @NotNull
    public String getNamespaceURI() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    }

    @NotNull
    public String getLocalPart() {
        return "Security";
    }

    @Nullable
    public String getAttribute(@NotNull String nsUri, @NotNull String localName) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getAttribute(@NotNull QName name) {
        throw new UnsupportedOperationException();
    }

    public void writeTo(XMLStreamWriter streamWriter) throws XMLStreamException {
        this.orderHeaders();
        if (this.secHeaderContent.size() > 0) {
            streamWriter.writeStartElement("wsse", "Security", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            this.writeMustunderstand(streamWriter);
            for (SecurityHeaderElement el : this.secHeaderContent) {
                ((SecurityElementWriter)((Object)el)).writeTo(streamWriter);
            }
            streamWriter.writeEndElement();
        }
    }

    public void writeTo(SOAPMessage saaj) throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        throw new UnsupportedOperationException();
    }

    private void writeMustunderstand(XMLStreamWriter writer) throws XMLStreamException {
        if (this.mustUnderstandValue) {
            if (this.soapVersion == "http://schemas.xmlsoap.org/soap/envelope/") {
                writer.writeAttribute("S", "http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand", "1");
            } else if (this.soapVersion == "http://www.w3.org/2003/05/soap-envelope") {
                writer.writeAttribute("S", "http://www.w3.org/2003/05/soap-envelope", "mustUnderstand", "true");
            }
        } else if (this.soapVersion == "http://schemas.xmlsoap.org/soap/envelope/") {
            writer.writeAttribute("S", "http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand", "0");
        } else if (this.soapVersion == "http://www.w3.org/2003/05/soap-envelope") {
            writer.writeAttribute("S", "http://www.w3.org/2003/05/soap-envelope", "mustUnderstand", "false");
        }
    }

    private void orderHeaders() {
        if (this.headerLayout == 3) {
            this.laxTimestampLast();
        } else if (this.headerLayout == 2) {
            this.laxTimestampFirst();
        } else if (this.headerLayout == 1) {
            this.strict();
        } else {
            this.strict();
        }
    }

    private void laxTimestampLast() {
        this.strict();
        SecurityHeaderElement timestamp = this.secHeaderContent.get(0);
        if (timestamp != null && timestamp instanceof Timestamp) {
            this.secHeaderContent.remove(0);
            this.secHeaderContent.add(timestamp);
        }
    }

    private void laxTimestampFirst() {
        this.strict();
    }

    private void print(ArrayList<SecurityHeaderElement> list) {
        if (!this.debug) {
            return;
        }
        System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++");
        for (int j = 0; j < list.size(); ++j) {
            System.out.println(list.get(j));
        }
        System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++");
    }

    private void strict() {
        int i;
        ArrayList<SecurityHeaderElement> primaryElementList = new ArrayList<SecurityHeaderElement>();
        ArrayList<SecurityHeaderElement> topElementList = new ArrayList<SecurityHeaderElement>();
        int len = this.secHeaderContent.size();
        this.print(this.secHeaderContent);
        SecurityHeaderElement timeStamp = null;
        for (int i2 = 0; i2 < len; ++i2) {
            SecurityHeaderElement she = this.secHeaderContent.get(i2);
            if (she.getLocalPart() == "Timestamp") {
                timeStamp = she;
                continue;
            }
            if (this.isTopLevelElement(she)) {
                topElementList.add(she);
                continue;
            }
            primaryElementList.add(0, she);
        }
        this.print(topElementList);
        topElementList = this.orderList(topElementList);
        this.print(primaryElementList);
        primaryElementList = this.orderList(primaryElementList);
        ArrayList<SecurityHeaderElement> tmpList = new ArrayList<SecurityHeaderElement>();
        block1: for (i = 0; i < primaryElementList.size(); ++i) {
            SecurityHeaderElement she = primaryElementList.get(i);
            if (she.getLocalPart() != "ReferenceList" && she.getLocalPart() != "EncryptedKey") continue;
            int tLen = topElementList.size();
            for (int j = tLen - 1; j >= 0; --j) {
                SecurityHeaderElement tk = topElementList.get(j);
                if (!she.refersToSecHdrWithId(tk.getId())) continue;
                topElementList.add(j + 1, she);
                tmpList.add(she);
                continue block1;
            }
        }
        primaryElementList.removeAll(tmpList);
        this.secHeaderContent.clear();
        for (i = topElementList.size() - 1; i >= 0; --i) {
            this.secHeaderContent.add(topElementList.get(i));
        }
        for (i = primaryElementList.size() - 1; i >= 0; --i) {
            this.secHeaderContent.add(primaryElementList.get(i));
        }
        if (timeStamp != null) {
            this.secHeaderContent.add(0, timeStamp);
        }
    }

    private ArrayList<SecurityHeaderElement> orderList(ArrayList<SecurityHeaderElement> list) {
        ArrayList<SecurityHeaderElement> tmp = new ArrayList<SecurityHeaderElement>();
        for (int i = 0; i < list.size(); ++i) {
            SecurityHeaderElement securityElementOne = list.get(i);
            int wLen = tmp.size();
            boolean index = false;
            if (wLen == 0) {
                tmp.add(securityElementOne);
                continue;
            }
            int setIndex = -1;
            for (int j = 0; j < wLen; ++j) {
                SecurityHeaderElement securityElementTwo = tmp.get(j);
                if (securityElementOne.refersToSecHdrWithId(securityElementTwo.getId())) {
                    if (securityElementTwo instanceof JAXBEncryptedData) {
                        if (securityElementOne instanceof JAXBEncryptedKey || securityElementOne.getLocalPart() == "ReferenceList") {
                            setIndex = j + 1;
                            continue;
                        }
                        setIndex = j;
                        continue;
                    }
                    setIndex = j;
                    continue;
                }
                if (securityElementTwo instanceof JAXBEncryptedData && this.refersToEncryptedElement(securityElementOne, securityElementTwo)) {
                    setIndex = j;
                    continue;
                }
                if (!securityElementTwo.refersToSecHdrWithId(securityElementOne.getId())) continue;
                setIndex = securityElementTwo instanceof JAXBEncryptedKey && securityElementOne instanceof JAXBEncryptedData ? j : j + 1;
            }
            if (tmp.contains(securityElementOne)) continue;
            if (setIndex == -1) {
                tmp.add(securityElementOne);
            } else {
                tmp.add(setIndex, securityElementOne);
            }
            this.print(tmp);
        }
        return tmp;
    }

    private boolean refersToEncryptedElement(SecurityHeaderElement securityElementOne, SecurityHeaderElement securityElementTwo) {
        return securityElementOne.refersToSecHdrWithId(((JAXBEncryptedData)securityElementTwo).getEncryptedId());
    }

    private void movePrevHeader(SecurityHeaderElement toBeMoved, int index) {
        int prevIndex = this.secHeaderContent.indexOf(toBeMoved);
        SecurityHeaderElement prev = this.secHeaderContent.get(prevIndex - 1);
        String prevId = prev.getId();
        this.secHeaderContent.remove(toBeMoved);
        this.secHeaderContent.add(index, toBeMoved);
        if (toBeMoved.refersToSecHdrWithId(prevId)) {
            this.movePrevHeader(prev, index);
        }
    }

    private boolean isTopLevelElement(SecurityHeaderElement she) {
        String localPart = she.getLocalPart();
        if (localPart.equals("EncryptedData")) {
            if (she instanceof GSHeaderElement) {
                return true;
            }
            localPart = ((JAXBEncryptedData)she).getEncryptedLocalName();
        }
        if (localPart == "BinarySecurityToken") {
            return true;
        }
        if (localPart == "SecurityContextToken") {
            return true;
        }
        if (localPart == "EncryptedKey") {
            return !((JAXBEncryptedKey)she).hasReferenceList();
        }
        if (localPart == "DerivedKeyToken") {
            return true;
        }
        if (localPart == "SignatureConfirmation") {
            return true;
        }
        if (localPart == "Timestamp") {
            return true;
        }
        if (localPart.equals("Assertion")) {
            return true;
        }
        return localPart == "UsernameToken";
    }
}

