/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;

public class ClassUseMapper {
    private final ClassTree classtree;
    public Map classToPackage = new HashMap();
    public Map classToPackageAnnotations = new HashMap();
    public Map classToClass = new HashMap();
    public Map classToSubclass = new HashMap();
    public Map classToSubinterface = new HashMap();
    public Map classToImplementingClass = new HashMap();
    public Map classToField = new HashMap();
    public Map classToMethodReturn = new HashMap();
    public Map classToMethodArgs = new HashMap();
    public Map classToMethodThrows = new HashMap();
    public Map classToConstructorArgs = new HashMap();
    public Map classToConstructorThrows = new HashMap();
    public Map classToConstructorAnnotations = new HashMap();
    public Map classToConstructorParamAnnotation = new HashMap();
    public Map classToConstructorDocArgTypeParam = new HashMap();
    public Map classToClassTypeParam = new HashMap();
    public Map classToClassAnnotations = new HashMap();
    public Map classToExecMemberDocTypeParam = new HashMap();
    public Map classToExecMemberDocArgTypeParam = new HashMap();
    public Map classToExecMemberDocAnnotations = new HashMap();
    public Map classToExecMemberDocReturnTypeParam = new HashMap();
    public Map classToExecMemberDocParamAnnotation = new HashMap();
    public Map classToFieldDocTypeParam = new HashMap();
    public Map annotationToFieldDoc = new HashMap();

    public ClassUseMapper(RootDoc rootDoc, ClassTree classTree) {
        this.classtree = classTree;
        ClassDoc[] classDocArray = classTree.baseclasses().iterator();
        while (classDocArray.hasNext()) {
            this.subclasses((ClassDoc)classDocArray.next());
        }
        classDocArray = classTree.baseinterfaces().iterator();
        while (classDocArray.hasNext()) {
            this.implementingClasses((ClassDoc)classDocArray.next());
        }
        classDocArray = rootDoc.classes();
        for (int i = 0; i < classDocArray.length; ++i) {
            MethodDoc[] methodDocArray;
            PackageDoc packageDoc = classDocArray[i].containingPackage();
            this.mapAnnotations(this.classToPackageAnnotations, packageDoc, packageDoc);
            ClassDoc classDoc = classDocArray[i];
            this.mapTypeParameters(this.classToClassTypeParam, classDoc, classDoc);
            this.mapAnnotations(this.classToClassAnnotations, classDoc, classDoc);
            FieldDoc[] fieldDocArray = classDoc.fields();
            for (int j = 0; j < fieldDocArray.length; ++j) {
                methodDocArray = fieldDocArray[j];
                this.mapTypeParameters(this.classToFieldDocTypeParam, methodDocArray, (ProgramElementDoc)methodDocArray);
                this.mapAnnotations(this.annotationToFieldDoc, methodDocArray, methodDocArray);
                if (methodDocArray.type().isPrimitive()) continue;
                this.add(this.classToField, methodDocArray.type().asClassDoc(), (ProgramElementDoc)methodDocArray);
            }
            ConstructorDoc[] constructorDocArray = classDoc.constructors();
            for (int j = 0; j < constructorDocArray.length; ++j) {
                this.mapAnnotations(this.classToConstructorAnnotations, constructorDocArray[j], constructorDocArray[j]);
                this.mapExecutable(constructorDocArray[j]);
            }
            methodDocArray = classDoc.methods();
            for (int j = 0; j < methodDocArray.length; ++j) {
                MethodDoc methodDoc = methodDocArray[j];
                this.mapExecutable(methodDoc);
                this.mapTypeParameters(this.classToExecMemberDocTypeParam, methodDoc, methodDoc);
                this.mapAnnotations(this.classToExecMemberDocAnnotations, methodDoc, methodDoc);
                if (methodDoc.returnType().isPrimitive() || methodDoc.returnType() instanceof TypeVariable) continue;
                this.mapTypeParameters(this.classToExecMemberDocReturnTypeParam, methodDoc.returnType(), methodDoc);
                this.add(this.classToMethodReturn, methodDoc.returnType().asClassDoc(), methodDoc);
            }
        }
    }

    private Collection subclasses(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToSubclass.get(classDoc.qualifiedName());
        if (treeSet == null) {
            treeSet = new TreeSet();
            List list = this.classtree.subclasses(classDoc);
            if (list != null) {
                treeSet.addAll(list);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    treeSet.addAll(this.subclasses((ClassDoc)iterator.next()));
                }
            }
            this.addAll(this.classToSubclass, classDoc, treeSet);
        }
        return treeSet;
    }

    private Collection subinterfaces(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToSubinterface.get(classDoc.qualifiedName());
        if (treeSet == null) {
            treeSet = new TreeSet();
            List list = this.classtree.subinterfaces(classDoc);
            if (list != null) {
                treeSet.addAll(list);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    treeSet.addAll(this.subinterfaces((ClassDoc)iterator.next()));
                }
            }
            this.addAll(this.classToSubinterface, classDoc, treeSet);
        }
        return treeSet;
    }

    private Collection implementingClasses(ClassDoc classDoc) {
        SequencedCollection sequencedCollection = (List)this.classToImplementingClass.get(classDoc.qualifiedName());
        if (sequencedCollection == null) {
            Iterator iterator;
            sequencedCollection = new TreeSet();
            List list = this.classtree.implementingclasses(classDoc);
            if (list != null) {
                sequencedCollection.addAll(list);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    sequencedCollection.addAll(this.subclasses((ClassDoc)iterator.next()));
                }
            }
            iterator = this.subinterfaces(classDoc).iterator();
            while (iterator.hasNext()) {
                sequencedCollection.addAll(this.implementingClasses((ClassDoc)iterator.next()));
            }
            this.addAll(this.classToImplementingClass, classDoc, sequencedCollection);
        }
        return sequencedCollection;
    }

    private void mapExecutable(ExecutableMemberDoc executableMemberDoc) {
        Parameter[] parameterArray = executableMemberDoc.parameters();
        boolean bl = executableMemberDoc.isConstructor();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 0; i < parameterArray.length; ++i) {
            Type type = parameterArray[i].type();
            if (!(parameterArray[i].type().isPrimitive() || arrayList.contains(type) || type instanceof TypeVariable)) {
                this.add(bl ? this.classToConstructorArgs : this.classToMethodArgs, type.asClassDoc(), executableMemberDoc);
                arrayList.add(type);
                this.mapTypeParameters(bl ? this.classToConstructorDocArgTypeParam : this.classToExecMemberDocArgTypeParam, type, executableMemberDoc);
            }
            this.mapAnnotations(bl ? this.classToConstructorParamAnnotation : this.classToExecMemberDocParamAnnotation, parameterArray[i], executableMemberDoc);
        }
        ClassDoc[] classDocArray = executableMemberDoc.thrownExceptions();
        for (int i = 0; i < classDocArray.length; ++i) {
            this.add(bl ? this.classToConstructorThrows : this.classToMethodThrows, classDocArray[i], executableMemberDoc);
        }
    }

    private List refList(Map map, ClassDoc classDoc) {
        ArrayList arrayList = (ArrayList)map.get(classDoc.qualifiedName());
        if (arrayList == null) {
            arrayList = new ArrayList();
            map.put(classDoc.qualifiedName(), arrayList);
        }
        return arrayList;
    }

    private Set packageSet(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToPackage.get(classDoc.qualifiedName());
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.classToPackage.put(classDoc.qualifiedName(), treeSet);
        }
        return treeSet;
    }

    private Set classSet(ClassDoc classDoc) {
        TreeSet treeSet = (TreeSet)this.classToClass.get(classDoc.qualifiedName());
        if (treeSet == null) {
            treeSet = new TreeSet();
            this.classToClass.put(classDoc.qualifiedName(), treeSet);
        }
        return treeSet;
    }

    private void add(Map map, ClassDoc classDoc, ProgramElementDoc programElementDoc) {
        this.refList(map, classDoc).add(programElementDoc);
        this.packageSet(classDoc).add(programElementDoc.containingPackage());
        this.classSet(classDoc).add(programElementDoc instanceof MemberDoc ? ((MemberDoc)programElementDoc).containingClass() : programElementDoc);
    }

    private void addAll(Map map, ClassDoc classDoc, Collection collection) {
        if (collection == null) {
            return;
        }
        this.refList(map, classDoc).addAll(collection);
        Set set = this.packageSet(classDoc);
        Set set2 = this.classSet(classDoc);
        for (ProgramElementDoc programElementDoc : collection) {
            set.add(programElementDoc.containingPackage());
            set2.add(programElementDoc instanceof MemberDoc ? ((MemberDoc)programElementDoc).containingClass() : programElementDoc);
        }
    }

    private void mapTypeParameters(Map map, Object object, ProgramElementDoc programElementDoc) {
        TypeVariable[] typeVariableArray;
        if (object instanceof ClassDoc) {
            typeVariableArray = ((ClassDoc)object).typeParameters();
        } else {
            if (object instanceof WildcardType) {
                Type[] typeArray = ((WildcardType)object).extendsBounds();
                for (int i = 0; i < typeArray.length; ++i) {
                    this.addTypeParameterToMap(map, typeArray[i], programElementDoc);
                }
                Type[] typeArray2 = ((WildcardType)object).superBounds();
                for (int i = 0; i < typeArray2.length; ++i) {
                    this.addTypeParameterToMap(map, typeArray2[i], programElementDoc);
                }
                return;
            }
            if (object instanceof ParameterizedType) {
                Type[] typeArray = ((ParameterizedType)object).typeArguments();
                for (int i = 0; i < typeArray.length; ++i) {
                    this.addTypeParameterToMap(map, typeArray[i], programElementDoc);
                }
                return;
            }
            if (object instanceof ExecutableMemberDoc) {
                typeVariableArray = ((ExecutableMemberDoc)object).typeParameters();
            } else {
                if (object instanceof FieldDoc) {
                    Type type = ((FieldDoc)object).type();
                    this.mapTypeParameters(map, type, programElementDoc);
                    return;
                }
                return;
            }
        }
        for (int i = 0; i < typeVariableArray.length; ++i) {
            Type[] typeArray = typeVariableArray[i].bounds();
            for (int j = 0; j < typeArray.length; ++j) {
                this.addTypeParameterToMap(map, typeArray[j], programElementDoc);
            }
        }
    }

    private void mapAnnotations(Map map, Object object, Object object2) {
        AnnotationDesc[] annotationDescArray;
        boolean bl = false;
        if (object instanceof ProgramElementDoc) {
            annotationDescArray = ((ProgramElementDoc)object).annotations();
        } else if (object instanceof PackageDoc) {
            annotationDescArray = ((PackageDoc)object).annotations();
            bl = true;
        } else if (object instanceof Parameter) {
            annotationDescArray = ((Parameter)object).annotations();
        } else {
            throw new DocletAbortException();
        }
        for (int i = 0; i < annotationDescArray.length; ++i) {
            AnnotationTypeDoc annotationTypeDoc = annotationDescArray[i].annotationType();
            if (bl) {
                this.refList(map, annotationTypeDoc).add(object2);
                continue;
            }
            this.add(map, annotationTypeDoc, (ProgramElementDoc)object2);
        }
    }

    private void addTypeParameterToMap(Map map, Type type, ProgramElementDoc programElementDoc) {
        if (type instanceof ClassDoc) {
            this.add(map, (ClassDoc)type, programElementDoc);
        } else if (type instanceof ParameterizedType) {
            this.add(map, ((ParameterizedType)type).asClassDoc(), programElementDoc);
        }
        this.mapTypeParameters(map, type, programElementDoc);
    }
}

