/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jruby;

import com.sun.script.jruby.JRubyScriptEngineFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyIO;
import org.jruby.RubyObject;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ReadonlyAccessor;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.KCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private ScriptEngineFactory factory;
    private Ruby runtime;
    private boolean autoTerminate = true;

    public JRubyScriptEngine() {
        this(System.getProperty("com.sun.script.jruby.loadpath"));
    }

    public JRubyScriptEngine(String loadPath) {
        this.init(loadPath);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        JavaEmbedUtils.EvalUnit unit = this.compileScript(script, this.context);
        return new JRubyCompiledScript(unit);
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        JavaEmbedUtils.EvalUnit unit = this.compileScript(reader, this.context);
        return new JRubyCompiledScript(unit);
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeImpl(null, name, args, Object.class);
    }

    @Override
    public Object invokeMethod(Object obj, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        if (obj == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.invokeImpl(obj, name, args, Object.class);
    }

    @Override
    public <T> T getInterface(Object obj, Class<T> clazz) {
        if (obj == null) {
            throw new IllegalArgumentException("script object is null");
        }
        return this.makeInterface(obj, clazz);
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        return this.makeInterface(null, clazz);
    }

    private <T> T makeInterface(Object obj, Class<T> clazz) {
        if (clazz == null || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        final Object thiz = obj;
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                return JRubyScriptEngine.this.invokeImpl(thiz, m.getName(), args, m.getReturnType());
            }
        });
    }

    @Override
    public synchronized Object eval(String str, ScriptContext ctx) throws ScriptException {
        JavaEmbedUtils.EvalUnit unit = this.compileScript(str, ctx);
        return this.evalNode(unit, ctx);
    }

    @Override
    public synchronized Object eval(Reader reader, ScriptContext ctx) throws ScriptException {
        JavaEmbedUtils.EvalUnit unit = this.compileScript(reader, ctx);
        return this.evalNode(unit, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngineFactory getFactory() {
        JRubyScriptEngine jRubyScriptEngine = this;
        synchronized (jRubyScriptEngine) {
            if (this.factory == null) {
                this.factory = new JRubyScriptEngineFactory();
            }
        }
        return this.factory;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    void setFactory(ScriptEngineFactory factory) {
        this.factory = factory;
    }

    private Object rubyToJava(IRubyObject value) {
        return this.rubyToJava(value, Object.class);
    }

    private Object rubyToJava(IRubyObject value, Class type) {
        return JavaUtil.convertArgument((Ruby)this.runtime, (Object)Java.ruby_to_java((IRubyObject)value, (IRubyObject)value, (Block)Block.NULL_BLOCK), (Class)type);
    }

    private IRubyObject javaToRuby(Object value) {
        if (value instanceof IRubyObject) {
            return (IRubyObject)value;
        }
        IRubyObject result = JavaUtil.convertJavaToRuby((Ruby)this.runtime, (Object)value);
        if (result instanceof JavaObject) {
            return this.runtime.getModule("JavaUtilities").callMethod(this.runtime.getCurrentContext(), "wrap", result);
        }
        return result;
    }

    private synchronized JavaEmbedUtils.EvalUnit compileScript(String script, ScriptContext ctx) throws ScriptException {
        GlobalVariables oldGlobals = this.runtime.getGlobalVariables();
        try {
            this.setErrorWriter(ctx.getErrorWriter());
            this.setGlobalVariables(ctx);
            String filename = (String)ctx.getAttribute("javax.script.filename");
            if (filename == null) {
                filename = "<unknown>";
            }
            RubyRuntimeAdapter adapter = JavaEmbedUtils.newRuntimeAdapter();
            JavaEmbedUtils.EvalUnit evalUnit = adapter.parse(this.runtime, script, filename, 0);
            return evalUnit;
        }
        catch (RaiseException e) {
            RubyException re = e.getException();
            this.runtime.printError(re);
            throw new ScriptException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            if (oldGlobals != null) {
                this.setGlobalVariables(oldGlobals);
            }
        }
    }

    private synchronized JavaEmbedUtils.EvalUnit compileScript(Reader reader, ScriptContext ctx) throws ScriptException {
        GlobalVariables oldGlobals = this.runtime.getGlobalVariables();
        try {
            this.setErrorWriter(ctx.getErrorWriter());
            this.setGlobalVariables(ctx);
            String filename = (String)ctx.getAttribute("javax.script.filename");
            RubyRuntimeAdapter adapter = JavaEmbedUtils.newRuntimeAdapter();
            if (filename == null) {
                filename = "<unknown>";
                String script = this.getRubyScript(reader);
                JavaEmbedUtils.EvalUnit evalUnit = adapter.parse(this.runtime, script, filename, 0);
                return evalUnit;
            }
            InputStream inputStream = this.getRubyReader(filename);
            JavaEmbedUtils.EvalUnit evalUnit = adapter.parse(this.runtime, inputStream, filename, 0);
            return evalUnit;
        }
        catch (RaiseException e) {
            RubyException re = e.getException();
            this.runtime.printError(re);
            throw new ScriptException((Exception)((Object)e));
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        finally {
            if (oldGlobals != null) {
                this.setGlobalVariables(oldGlobals);
            }
        }
    }

    private String getRubyScript(Reader reader) throws IOException {
        char[] cbuf;
        int chars;
        StringBuffer sb = new StringBuffer();
        while ((chars = reader.read(cbuf = new char[8192], 0, cbuf.length)) >= 0) {
            sb.append(cbuf, 0, chars);
        }
        cbuf = null;
        return new String(sb).trim();
    }

    private InputStream getRubyReader(String filename) throws FileNotFoundException {
        File file = new File(filename);
        return new FileInputStream(file);
    }

    private void setGlobalVariables(final ScriptContext ctx) {
        ctx.setAttribute("context", ctx, 100);
        this.setGlobalVariables(new GlobalVariables(this.runtime){
            GlobalVariables parent;
            {
                super(x0);
                this.parent = JRubyScriptEngine.this.runtime.getGlobalVariables();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void define(String name, IAccessor accessor) {
                assert (name != null);
                assert (accessor != null);
                assert (name.startsWith("$"));
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    Bindings engineScope = ctx.getBindings(100);
                    engineScope.put(name, (Object)new GlobalVariable(accessor));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void defineReadonly(String name, IAccessor accessor) {
                assert (name != null);
                assert (accessor != null);
                assert (name.startsWith("$"));
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    Bindings engineScope = ctx.getBindings(100);
                    engineScope.put(name, (Object)new GlobalVariable((IAccessor)new ReadonlyAccessor(name, accessor)));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isDefined(String name) {
                assert (name != null);
                assert (name.startsWith("$"));
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    String modifiedName = name.substring(1);
                    boolean defined = ctx.getAttributesScope(modifiedName) != -1;
                    return defined ? true : this.parent.isDefined(name);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alias(String name, String oldName) {
                assert (name != null);
                assert (oldName != null);
                assert (name.startsWith("$"));
                assert (oldName.startsWith("$"));
                if (JRubyScriptEngine.this.runtime.getSafeLevel() >= 4) {
                    throw JRubyScriptEngine.this.runtime.newSecurityError("Insecure: can't alias global variable");
                }
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    int scope = ctx.getAttributesScope(name);
                    if (scope == -1) {
                        scope = 100;
                    }
                    IRubyObject value = this.get(oldName);
                    ctx.setAttribute(name, JRubyScriptEngine.this.rubyToJava(value), scope);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject get(String name) {
                assert (name != null);
                assert (name.startsWith("$"));
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    String modifiedName = name.substring(1);
                    int scope = ctx.getAttributesScope(modifiedName);
                    if (scope == -1) {
                        return this.parent.get(name);
                    }
                    Object obj = ctx.getAttribute(modifiedName, scope);
                    if (obj instanceof IAccessor) {
                        return ((IAccessor)obj).getValue();
                    }
                    return JRubyScriptEngine.this.javaToRuby(obj);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject set(String name, IRubyObject value) {
                assert (name != null);
                assert (name.startsWith("$"));
                if (JRubyScriptEngine.this.runtime.getSafeLevel() >= 4) {
                    throw JRubyScriptEngine.this.runtime.newSecurityError("Insecure: can't change global variable value");
                }
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    String modifiedName = name.substring(1);
                    int scope = ctx.getAttributesScope(modifiedName);
                    if (scope == -1) {
                        scope = 100;
                    }
                    IRubyObject oldValue = this.get(name);
                    Object obj = ctx.getAttribute(modifiedName, scope);
                    if (obj instanceof IAccessor) {
                        ((IAccessor)obj).setValue(value);
                    } else {
                        ctx.setAttribute(modifiedName, JRubyScriptEngine.this.rubyToJava(value), scope);
                        if ("KCODE".equals(modifiedName)) {
                            JRubyScriptEngine.this.setKCode((String)JRubyScriptEngine.this.rubyToJava(value));
                        } else if ("stdout".equals(modifiedName)) {
                            JRubyScriptEngine.this.equalOutputs((RubyObject)value);
                        }
                    }
                    return oldValue;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Set<String> getNames() {
                HashSet<String> set = new HashSet<String>();
                ScriptContext scriptContext = ctx;
                synchronized (scriptContext) {
                    for (int scope : ctx.getScopes()) {
                        Bindings b = ctx.getBindings(scope);
                        if (b == null) continue;
                        for (String key : b.keySet()) {
                            set.add(key);
                        }
                    }
                }
                Iterator names = this.parent.getNames().iterator();
                while (names.hasNext()) {
                    set.add((String)names.next());
                }
                return Collections.unmodifiableSet(set);
            }

            public IRubyObject getDefaultSeparator() {
                return this.parent.getDefaultSeparator();
            }
        });
    }

    private void setGlobalVariables(GlobalVariables globals) {
        this.runtime.setGlobalVariables(globals);
    }

    private void checkAutoTermination() {
        String p = System.getProperty("com.sun.script.jruby.terminator");
        if (p != null) {
            if ("on".equals(p)) {
                this.autoTerminate = true;
            } else if ("off".equals(p)) {
                this.autoTerminate = false;
            } else {
                throw new IllegalArgumentException("com.sun.script.jruby.terminator property should be on or off.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object evalNodeWithAutoTermination(JavaEmbedUtils.EvalUnit unit) throws Exception {
        try {
            Object object = JavaEmbedUtils.rubyToJava((Ruby)this.runtime, (IRubyObject)unit.run(), Object.class);
            return object;
        }
        finally {
            block7: {
                try {
                    JavaEmbedUtils.terminate((Ruby)this.runtime);
                }
                catch (RaiseException e) {
                    RubyException re = e.getException();
                    this.runtime.printError(re);
                    if (this.runtime.fastGetClass("SystemExit").isInstance((IRubyObject)re)) break block7;
                    throw new ScriptException((Exception)((Object)e));
                }
            }
        }
    }

    private Object evalNodeWithoutAutoTermination(JavaEmbedUtils.EvalUnit unit) {
        IRubyObject result = unit.run();
        return JavaEmbedUtils.rubyToJava((Ruby)this.runtime, (IRubyObject)result, Object.class);
    }

    private synchronized Object evalNode(JavaEmbedUtils.EvalUnit unit, ScriptContext ctx) throws ScriptException {
        GlobalVariables oldGlobals = this.runtime.getGlobalVariables();
        try {
            this.setWriterOutputStream(ctx.getWriter());
            this.setErrorWriter(ctx.getErrorWriter());
            this.setGlobalVariables(ctx);
            this.checkAutoTermination();
            if (this.autoTerminate) {
                Object object = this.evalNodeWithAutoTermination(unit);
                return object;
            }
            Object object = this.evalNodeWithoutAutoTermination(unit);
            return object;
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        finally {
            if (oldGlobals != null) {
                this.setGlobalVariables(oldGlobals);
            }
        }
    }

    private void init(String loadPath) {
        this.runtime = Ruby.newInstance();
        ValueAccessor d = new ValueAccessor((IRubyObject)this.runtime.newString("<script>"));
        this.runtime.getGlobalVariables().define("$PROGRAM_NAME", (IAccessor)d);
        this.runtime.getGlobalVariables().define("$0", (IAccessor)d);
        if (loadPath == null) {
            loadPath = System.getProperty("java.class.path");
        }
        List<String> list = Arrays.asList(loadPath.split(File.pathSeparator));
        this.runtime.getLoadService().init(list);
        this.runtime.getLoadService().require("java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Object invokeImpl(Object obj, String method, Object[] args, Class returnType) throws ScriptException {
        if (method == null) {
            throw new NullPointerException("method name is null");
        }
        GlobalVariables oldGlobals = this.runtime.getGlobalVariables();
        try {
            IRubyObject result;
            IRubyObject rubyRecv;
            this.setWriterOutputStream(this.context.getWriter());
            this.setErrorWriter(this.context.getErrorWriter());
            this.setGlobalVariables(this.context);
            IRubyObject iRubyObject = rubyRecv = obj != null ? JavaUtil.convertJavaToRuby((Ruby)this.runtime, (Object)obj) : this.runtime.getTopSelf();
            if (args != null && args.length > 0) {
                IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby((Ruby)this.runtime, (Object[])args);
                IRubyObject javaUtilities = this.runtime.getObject().getConstant("JavaUtilities");
                for (int i = 0; i < rubyArgs.length; ++i) {
                    IRubyObject tmp = rubyArgs[i];
                    if (!(tmp instanceof JavaObject)) continue;
                    rubyArgs[i] = javaUtilities.callMethod(this.runtime.getCurrentContext(), "wrap", tmp);
                }
                result = rubyRecv.callMethod(this.runtime.getCurrentContext(), method, rubyArgs);
            } else {
                result = rubyRecv.callMethod(this.runtime.getCurrentContext(), method);
            }
            Object object = this.rubyToJava(result, returnType);
            return object;
        }
        catch (Exception exp) {
            throw new ScriptException(exp);
        }
        finally {
            try {
                JavaEmbedUtils.terminate((Ruby)this.runtime);
            }
            catch (RaiseException e) {
                RubyException re = e.getException();
                this.runtime.printError(re);
                if (!this.runtime.fastGetClass("SystemExit").isInstance((IRubyObject)re)) {
                    throw new ScriptException((Exception)((Object)e));
                }
            }
            finally {
                if (oldGlobals != null) {
                    this.setGlobalVariables(oldGlobals);
                }
            }
        }
    }

    private void setKCode(String encoding) {
        KCode kcode = KCode.create((Ruby)this.runtime, (String)encoding);
        this.runtime.setKCode(kcode);
    }

    private void equalOutputs(RubyObject value) {
        this.runtime.getGlobalVariables().set("$>", (IRubyObject)value);
        this.runtime.getGlobalVariables().set("$defout", (IRubyObject)value);
    }

    private void setWriterOutputStream(Writer writer) {
        try {
            RubyIO dummy_io = new RubyIO(this.runtime, (OutputStream)new PrintStream(new WriterOutputStream((Writer)new StringWriter())));
            this.runtime.getGlobalVariables().set("$stderr", (IRubyObject)dummy_io);
            RubyIO io = new RubyIO(this.runtime, (OutputStream)new PrintStream(new WriterOutputStream(writer)));
            io.getOpenFile().getMainStream().setSync(true);
            this.runtime.defineGlobalConstant("STDOUT", (IRubyObject)io);
            this.runtime.getGlobalVariables().set("$>", (IRubyObject)io);
            this.runtime.getGlobalVariables().set("$stdout", (IRubyObject)io);
            this.runtime.getGlobalVariables().set("$defout", (IRubyObject)io);
        }
        catch (UnsupportedEncodingException exp) {
            throw new IllegalArgumentException(exp);
        }
    }

    private void setErrorWriter(Writer writer) {
        try {
            RubyIO dummy_io = new RubyIO(this.runtime, (OutputStream)new PrintStream(new WriterOutputStream((Writer)new StringWriter())));
            this.runtime.getGlobalVariables().set("$stderr", (IRubyObject)dummy_io);
            RubyIO io = new RubyIO(this.runtime, (OutputStream)new PrintStream(new WriterOutputStream(writer)));
            io.getOpenFile().getMainStream().setSync(true);
            this.runtime.defineGlobalConstant("STDERR", (IRubyObject)io);
            this.runtime.getGlobalVariables().set("$stderr", (IRubyObject)io);
            this.runtime.getGlobalVariables().set("$deferr", (IRubyObject)io);
        }
        catch (UnsupportedEncodingException exp) {
            throw new IllegalArgumentException(exp);
        }
    }

    private String getEncoding(Writer writer) {
        if (writer instanceof OutputStreamWriter) {
            return ((OutputStreamWriter)writer).getEncoding();
        }
        String enc = System.getProperty("file.encoding");
        return enc == null ? "UTF-8" : enc;
    }

    private class WriterOutputStream
    extends OutputStream {
        private Writer writer;
        private CharsetDecoder decoder;

        private WriterOutputStream(Writer writer) throws UnsupportedEncodingException {
            this(writer, jRubyScriptEngine.getEncoding(writer));
        }

        private WriterOutputStream(Writer writer, String enc) throws UnsupportedEncodingException {
            this.writer = writer;
            if (enc == null) {
                throw new UnsupportedEncodingException("encoding is " + enc);
            }
            try {
                this.decoder = Charset.forName(enc).newDecoder();
            }
            catch (Exception e) {
                throw new UnsupportedEncodingException("Unsupported: " + enc);
            }
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Writer writer = this.writer;
            synchronized (writer) {
                this.decoder = null;
                this.writer.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            Writer writer = this.writer;
            synchronized (writer) {
                this.writer.flush();
            }
        }

        public void write(int b) throws IOException {
            byte[] buffer = new byte[1];
            this.write(buffer, 0, 1);
        }

        public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buffer, int offset, int length) throws IOException {
            Writer writer = this.writer;
            synchronized (writer) {
                if (offset < 0 || offset > buffer.length - length || length < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (length == 0) {
                    return;
                }
                ByteBuffer bytes = ByteBuffer.wrap(buffer, offset, length);
                CharBuffer chars = CharBuffer.allocate(length);
                this.convert(bytes, chars);
                char[] cbuf = new char[chars.length()];
                chars.get(cbuf, 0, chars.length());
                this.writer.write(cbuf);
                this.writer.flush();
            }
        }

        private void convert(ByteBuffer bytes, CharBuffer chars) throws IOException {
            this.decoder.reset();
            chars.clear();
            CoderResult result = this.decoder.decode(bytes, chars, true);
            if (result.isError() || result.isOverflow()) {
                throw new IOException(result.toString());
            }
            if (result.isUnderflow()) {
                chars.flip();
            }
        }
    }

    private class JRubyCompiledScript
    extends CompiledScript {
        private JavaEmbedUtils.EvalUnit unit;

        JRubyCompiledScript(JavaEmbedUtils.EvalUnit unit) {
            this.unit = unit;
        }

        public ScriptEngine getEngine() {
            return JRubyScriptEngine.this;
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            return JRubyScriptEngine.this.evalNode(this.unit, ctx);
        }
    }
}

