/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.wadl;

import com.sun.jersey.wadl.Dependency;
import com.sun.jersey.wadl.util.Loader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractMojoProjectClasspathSupport
extends AbstractMojo {
    private List<Dependency> _dependencies;
    private MavenProject mavenProject;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;

    public final void execute() throws MojoExecutionException {
        List<String> classpathElements;
        try {
            classpathElements = this.getClasspathElements(this.mavenProject, this._dependencies);
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Could not create the list of classpath elements.", e);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Loader ncl = new Loader(classpathElements.toArray(new String[0]), ((Object)((Object)this)).getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(ncl);
        try {
            this.executeWithClasspath(classpathElements);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Could not execute mojo", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    protected abstract void executeWithClasspath(List<String> var1) throws MojoExecutionException;

    protected List<String> getClasspathElements(MavenProject mavenProject, List<Dependency> additionalDependencies) throws DependencyResolutionRequiredException, ArtifactResolutionException, ArtifactNotFoundException {
        Artifact artifact;
        ArrayList<String> paths = new ArrayList<String>();
        List compileClasspathElements = mavenProject.getCompileClasspathElements();
        paths.addAll(compileClasspathElements);
        List dependencies = mavenProject.getDependencies();
        if (dependencies != null) {
            for (org.apache.maven.model.Dependency dependency : dependencies) {
                if (dependency.getSystemPath() != null) {
                    this.getLog().debug((CharSequence)("Adding dependency with systemPath " + dependency.getSystemPath()));
                    paths.add(dependency.getSystemPath());
                    continue;
                }
                artifact = this.artifactFactory.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier());
                this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                this.getLog().debug((CharSequence)("Adding artifact " + artifact.getFile().getPath()));
                paths.add(artifact.getFile().getPath());
            }
        }
        if (additionalDependencies != null) {
            for (Dependency dependency : additionalDependencies) {
                if (dependency.getSystemPath() != null) {
                    this.getLog().debug((CharSequence)("Adding additional dependency with systemPath " + dependency.getSystemPath()));
                    paths.add(dependency.getSystemPath());
                    continue;
                }
                artifact = this.artifactFactory.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "jar", null);
                this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
                this.getLog().debug((CharSequence)("Adding additional artifact " + artifact.getFile().getPath()));
                paths.add(artifact.getFile().getPath());
            }
        }
        return paths;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this._dependencies = dependencies;
    }
}

