/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart.impl;

import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.MultiPart;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"multipart/*"})
public class MultiPartWriter
implements MessageBodyWriter<MultiPart> {
    @Context
    private Providers providers;
    private static int boundaryCounter = 0;

    public long getSize(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type);
    }

    public void writeTo(MultiPart entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream stream) throws IOException, WebApplicationException {
        String boundaryString;
        Object value;
        if (entity.getBodyParts() == null || entity.getBodyParts().size() < 1) {
            throw new WebApplicationException((Throwable)new IllegalArgumentException("Must specify at least one body part"));
        }
        if (entity.getParent() == null && (value = headers.getFirst((Object)"MIME-Version")) == null) {
            headers.putSingle((Object)"MIME-Version", (Object)"1.0");
        }
        Annotation[] emptyAnnotations = new Annotation[]{};
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        MediaType entityMediaType = (MediaType)headers.getFirst((Object)"Content-Type");
        if (entityMediaType == null) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("boundary", MultiPartWriter.createBoundary());
            entityMediaType = new MediaType("multipart", "mixed", parameters);
            headers.putSingle((Object)"Content-Type", (Object)entityMediaType);
        }
        if ((boundaryString = (String)entityMediaType.getParameters().get("boundary")) == null) {
            boundaryString = MultiPartWriter.createBoundary();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.putAll(entityMediaType.getParameters());
            parameters.put("boundary", boundaryString);
            entityMediaType = new MediaType(entityMediaType.getType(), entityMediaType.getSubtype(), parameters);
            headers.putSingle((Object)"Content-Type", (Object)entityMediaType);
        }
        for (BodyPart bodyPart : entity.getBodyParts()) {
            writer.write("\r\n--");
            writer.write(boundaryString);
            writer.write("\r\n");
            MediaType bodyMediaType = bodyPart.getMediaType();
            if (bodyMediaType == null) {
                throw new WebApplicationException((Throwable)new IllegalArgumentException("Missing body part media type"));
            }
            MultivaluedMap<String, String> bodyHeaders = bodyPart.getHeaders();
            bodyHeaders.putSingle((Object)"Content-Type", (Object)bodyMediaType.toString());
            for (Map.Entry entry : bodyHeaders.entrySet()) {
                if (!((String)entry.getKey()).toLowerCase().startsWith("content-")) {
                    throw new WebApplicationException((Throwable)new IllegalArgumentException("Invalid body part header '" + (String)entry.getKey() + "', only Content-* allowed"));
                }
                writer.write((String)entry.getKey());
                ((Writer)writer).write(58);
                boolean first = true;
                for (String value2 : (List)entry.getValue()) {
                    if (first) {
                        ((Writer)writer).write(32);
                        first = false;
                    } else {
                        ((Writer)writer).write(44);
                    }
                    writer.write(value2.toString());
                }
                writer.write("\r\n");
            }
            writer.write("\r\n");
            ((Writer)writer).flush();
            Object bodyEntity = bodyPart.getEntity();
            if (bodyEntity == null) {
                throw new WebApplicationException((Throwable)new IllegalArgumentException("Missing body part entity of type '" + bodyMediaType + "'"));
            }
            MessageBodyWriter bodyWriter = this.providers.getMessageBodyWriter(bodyEntity.getClass(), bodyEntity.getClass(), emptyAnnotations, bodyMediaType);
            if (bodyWriter == null) {
                throw new WebApplicationException((Throwable)new IllegalArgumentException("No MessageBodyWriter for body part of type '" + bodyEntity.getClass().getName() + "' and media type '" + bodyMediaType + "'"));
            }
            bodyWriter.writeTo(bodyEntity, bodyEntity.getClass(), bodyEntity.getClass(), emptyAnnotations, bodyMediaType, bodyHeaders, stream);
        }
        writer.write("\r\n--");
        writer.write(boundaryString);
        writer.write("--\r\n");
        ((Writer)writer).flush();
    }

    private static synchronized String createBoundary() {
        StringBuilder sb = new StringBuilder();
        return "Boundary_" + ++boundaryCounter + "_" + sb.hashCode() + "_" + System.currentTimeMillis();
    }
}

