/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.internal.runlevel;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.LazyInhabitant;
import com.sun.hk2.component.RunLevelInhabitant;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.HabitatListener;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.RunLevelListener;
import org.jvnet.hk2.component.RunLevelService;
import org.jvnet.hk2.component.RunLevelState;
import org.jvnet.hk2.component.ServiceContext;
import org.jvnet.hk2.component.internal.runlevel.Recorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRunLevelService
implements RunLevelService<Void>,
RunLevelState<Void>,
InhabitantListener,
HabitatListener {
    static final boolean ASYNC_ENABLED = false;
    private final boolean asyncMode;
    private ExecutorService exec;
    private final Habitat habitat;
    private RunLevelState<Void> delegate;
    private volatile Integer current;
    private volatile Integer planned;
    private final HashMap<Integer, Recorder> recorders;
    private volatile Recorder activeRecorder;
    private volatile Integer activeRunLevel;
    private volatile Boolean upSide;
    private volatile Future<?> activeProceedToOp;

    public DefaultRunLevelService(Habitat habitat) {
        this(habitat, false, new LinkedHashMap<Integer, Recorder>());
    }

    DefaultRunLevelService(Habitat habitat, boolean async, HashMap<Integer, Recorder> recorders) {
        this.habitat = habitat;
        assert (null != habitat);
        this.asyncMode = async;
        if (this.asyncMode) {
            this.exec = Executors.newSingleThreadExecutor(new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    RunLevelServiceThread t = new RunLevelServiceThread(runnable);
                    return t;
                }
            });
        }
        this.recorders = recorders;
        habitat.addHabitatListener(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.current + ", " + this.planned + ", " + this.delegate + ")";
    }

    @Override
    public synchronized void proceedTo(final int runLevel) {
        if (runLevel < -1) {
            throw new IllegalArgumentException();
        }
        if (null != this.activeProceedToOp) {
            Logger.getAnonymousLogger().log(Level.INFO, "Cancelling activation to runLevel {0} and instead proceeding to {1}", new Object[]{this.planned, runLevel});
            this.activeProceedToOp.cancel(true);
            this.reset();
        }
        assert (null == this.activeRunLevel);
        assert (null == this.planned);
        this.planned = runLevel;
        if (null != this.exec) {
            this.activeProceedToOp = this.exec.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    DefaultRunLevelService.this.proceedToWorker(runLevel);
                    if (Thread.currentThread().isInterrupted()) {
                        DefaultRunLevelService.this.notify(ListenerEvent.CANCEL, null, null);
                    } else {
                        DefaultRunLevelService defaultRunLevelService = DefaultRunLevelService.this;
                        synchronized (defaultRunLevelService) {
                            DefaultRunLevelService.this.notifyAll();
                        }
                    }
                }
            });
        } else {
            this.proceedToWorker(runLevel);
        }
    }

    private void proceedToWorker(int runLevel) {
        int current;
        int n = current = null == this.getCurrentRunLevel() ? -2 : this.getCurrentRunLevel();
        if (runLevel > current) {
            for (int rl = current + 1; rl <= runLevel; ++rl) {
                this.upActiveRecorder(rl);
            }
        } else if (runLevel < current) {
            for (int rl = current; rl > runLevel; --rl) {
                this.downActiveRecorder(rl);
            }
        } else {
            this.current = current;
        }
    }

    private void reset() {
        this.activeRecorder = null;
        this.upSide = null;
        this.activeRunLevel = null;
        this.planned = null;
        this.activeProceedToOp = null;
    }

    private synchronized void upActiveRecorder(int runLevel) {
        this.upSide = true;
        this.activeRunLevel = runLevel;
        this.activateRunLevel();
        this.current = runLevel;
        this.activeRunLevel = null;
        if (this.planned == this.current) {
            this.reset();
        } else {
            this.activeRecorder = null;
        }
        this.notify(ListenerEvent.PROGRESS, null, null);
    }

    protected void activateRunLevel() {
        Collection<Inhabitant<?>> runLevelInhabitants = this.habitat.getAllInhabitantsByContract(RunLevel.class.getName());
        for (Inhabitant<?> i : runLevelInhabitants) {
            AbstractInhabitantImpl ai = (AbstractInhabitantImpl)AbstractInhabitantImpl.class.cast(i);
            RunLevel rl = ai.getAnnotation(RunLevel.class);
            if (rl.value() != this.activeRunLevel.intValue()) continue;
            Logger.getAnonymousLogger().log(Level.FINE, "activating {0}", i);
            try {
                i.get();
                assert (i.isInstantiated());
                if (RunLevelInhabitant.class.isInstance(ai)) continue;
                Logger.getAnonymousLogger().log(Level.WARNING, "{0} is not a RunLevelInhabitant and therefore will not be released during shutdown", ai);
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "exception caught from activation:", e);
                this.notify(ListenerEvent.ERROR, this.serviceContext(e, ai), e);
            }
        }
    }

    private synchronized void downActiveRecorder(int runLevel) {
        this.upSide = false;
        this.activeRunLevel = runLevel;
        Recorder downRecorder = this.recorders.remove(runLevel);
        if (null != downRecorder) {
            downRecorder.release();
        }
        this.current = runLevel - 1;
        if (this.planned == this.current) {
            this.reset();
        } else {
            this.activeRunLevel = null;
        }
        this.notify(ListenerEvent.PROGRESS, null, null);
    }

    private void notify(ListenerEvent event, ServiceContext context, Throwable error) {
        Collection<RunLevelListener> activeListeners = this.habitat.getAllByContract(RunLevelListener.class);
        for (RunLevelListener listener : activeListeners) {
            try {
                if (ListenerEvent.PROGRESS == event) {
                    listener.onProgress(this);
                    continue;
                }
                if (ListenerEvent.CANCEL == event) {
                    listener.onCancelled(this, this.current);
                    continue;
                }
                listener.onError(this, context, error, true);
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "exception caught from listener:", e);
            }
        }
    }

    private ServiceContext serviceContext(Exception e, final AbstractInhabitantImpl<?> ai) {
        ServiceContext ctx = null;
        if (e instanceof ComponentException) {
            ctx = ((ComponentException)e).getFailureContext();
        }
        if (null == ctx) {
            ctx = new ServiceContext(){

                @Override
                public ClassLoader getClassLoader() {
                    ClassLoader cl = LazyInhabitant.class.isInstance(ai) ? ((LazyInhabitant)ai).getClassLoader() : ai.getClass().getClassLoader();
                    return cl;
                }

                @Override
                public Inhabitant<?> getInhabitant() {
                    return ai;
                }

                @Override
                public String getType() {
                    return ai.typeName();
                }

                public String toString() {
                    return ai.toString();
                }
            };
        }
        return ctx;
    }

    void setDelegate(RunLevelState<Void> stateProvider) {
        assert (this != stateProvider);
        assert (this.getEnvironment() == stateProvider.getEnvironment());
        this.delegate = stateProvider;
    }

    @Override
    public RunLevelState<Void> getState() {
        return null == this.delegate ? this : this.delegate;
    }

    @Override
    public Class<Void> getEnvironment() {
        return null == this.delegate ? Void.class : this.delegate.getEnvironment();
    }

    @Override
    public Integer getCurrentRunLevel() {
        return null == this.delegate ? this.current : this.delegate.getCurrentRunLevel();
    }

    @Override
    public Integer getPlannedRunLevel() {
        return null == this.delegate ? this.planned : this.delegate.getPlannedRunLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inhabitantChanged(InhabitantListener.EventType eventType, Inhabitant<?> inhabitant) {
        if (InhabitantListener.class.isInstance(this.delegate)) {
            return ((InhabitantListener)InhabitantListener.class.cast(this.delegate)).inhabitantChanged(eventType, inhabitant);
        }
        if (null == this.activeRunLevel) {
            throw new ComponentException("problem: " + inhabitant);
        }
        if (this.upSide.booleanValue() && InhabitantListener.EventType.INHABITANT_ACTIVATED != eventType || !this.upSide.booleanValue() && InhabitantListener.EventType.INHABITANT_RELEASED != eventType) {
            throw new ComponentException("problem: " + inhabitant);
        }
        if (this.upSide.booleanValue()) {
            DefaultRunLevelService defaultRunLevelService = this;
            synchronized (defaultRunLevelService) {
                if (null == this.activeRecorder) {
                    this.activeRecorder = new Recorder(this.activeRunLevel);
                    if (null != this.recorders.put(this.activeRunLevel, this.activeRecorder)) {
                        throw new AssertionError((Object)"bad state");
                    }
                }
            }
        }
        if (null != this.activeRecorder) {
            this.activeRecorder.inhabitantChanged(eventType, inhabitant);
        }
        return true;
    }

    @Override
    public boolean inhabitantChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant) {
        if (HabitatListener.EventType.HABITAT_INITIALIZED == eventType) {
            this.proceedTo(-1);
        }
        return !habitat.isInitialized();
    }

    @Override
    public boolean inhabitantIndexChanged(HabitatListener.EventType eventType, Habitat habitat, Inhabitant<?> inhabitant, String index, String name, Object service) {
        return true;
    }

    private static class RunLevelServiceThread
    extends Thread {
        private RunLevelServiceThread(Runnable r) {
            super(r);
            this.setDaemon(true);
            this.setName(this.getClass().getSimpleName() + "-" + System.identityHashCode(this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ListenerEvent {
        PROGRESS,
        CANCEL,
        ERROR;

    }
}

