/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import com.sun.hk2.component.InjectionResolver;
import java.util.Collection;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantRequested;
import org.jvnet.hk2.component.InjectionManager;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Womb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWombImpl<T>
extends AbstractInhabitantImpl<T>
implements Womb<T> {
    protected final Class<T> type;
    protected final Habitat habitat;
    private final MultiMap<String, String> metadata;

    public AbstractWombImpl(Class<T> type, Habitat habitat, MultiMap<String, String> metadata) {
        this.type = type;
        this.habitat = habitat;
        this.metadata = metadata;
    }

    @Override
    public final String typeName() {
        return this.type.getName();
    }

    @Override
    public final Class<T> type() {
        return this.type;
    }

    @Override
    public final T get(Inhabitant onBehalfOf) throws ComponentException {
        Object o = this.create(onBehalfOf);
        this.initialize(o, onBehalfOf);
        return o;
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    @Override
    public void initialize(T t, Inhabitant onBehalfOf) throws ComponentException {
        if (t instanceof InhabitantRequested) {
            ((InhabitantRequested)t).setInhabitant(onBehalfOf);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public MultiMap<String, String> metadata() {
        return this.metadata;
    }

    protected void inject(Habitat habitat, T t, Inhabitant<?> onBehalfOf) {
        InjectionManager injectionMgr = new InjectionManager();
        Collection<InjectionResolver> targets = habitat.getAllByType(InjectionResolver.class);
        assert (!targets.isEmpty());
        injectionMgr.inject(t, onBehalfOf, targets.toArray(new InjectionResolver[targets.size()]));
        if (t instanceof PostConstruct) {
            ((PostConstruct)t).postConstruct();
        }
    }
}

