/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.server.PathContainer;
import org.springframework.util.Assert;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.resource.ResourceHandlerUtils;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

class PathResourceLookupFunction
implements Function<ServerRequest, Optional<Resource>> {
    private final PathPattern pattern;
    private final Resource location;

    public PathResourceLookupFunction(String pattern, Resource location) {
        Assert.hasLength((String)pattern, (String)"'pattern' must not be empty");
        Assert.notNull((Object)location, (String)"'location' must not be null");
        this.pattern = PathPatternParser.defaultInstance.parse(pattern);
        this.location = location;
    }

    @Override
    public Optional<Resource> apply(ServerRequest request) {
        PathContainer pathContainer = request.requestPath().pathWithinApplication();
        if (!this.pattern.matches(pathContainer)) {
            return Optional.empty();
        }
        String path = this.processPath((pathContainer = this.pattern.extractPathWithinPattern(pathContainer)).value());
        if (ResourceHandlerUtils.shouldIgnoreInputPath(path)) {
            return Optional.empty();
        }
        if (!(this.location instanceof UrlResource)) {
            path = UriUtils.decode((String)path, (Charset)StandardCharsets.UTF_8);
        }
        try {
            Resource resource = this.location.createRelative(path);
            if (resource.isReadable() && ResourceHandlerUtils.isResourceUnderLocation(this.location, resource)) {
                return Optional.of(resource);
            }
            return Optional.empty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected String processPath(String path) {
        return ResourceHandlerUtils.normalizeInputPath(path);
    }

    public String toString() {
        return this.pattern + " -> " + this.location;
    }
}

