/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.radar;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.radar.ValueListItem;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.radar.ValueListItemCreateParams;
import com.stripe.param.radar.ValueListItemListParams;
import com.stripe.param.radar.ValueListItemRetrieveParams;
import java.lang.reflect.Type;

public final class ValueListItemService
extends ApiService {
    public ValueListItemService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<ValueListItem> list(ValueListItemListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<ValueListItem> list(ValueListItemListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/radar/value_list_items";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<ValueListItem>>(){}.getType(), options, ApiMode.V1);
    }

    public ValueListItem create(ValueListItemCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public ValueListItem create(ValueListItemCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/radar/value_list_items";
        return (ValueListItem)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)ValueListItem.class), options, ApiMode.V1);
    }

    public ValueListItem retrieve(String item, ValueListItemRetrieveParams params) throws StripeException {
        return this.retrieve(item, params, null);
    }

    public ValueListItem retrieve(String item, RequestOptions options) throws StripeException {
        return this.retrieve(item, null, options);
    }

    public ValueListItem retrieve(String item) throws StripeException {
        return this.retrieve(item, null, null);
    }

    public ValueListItem retrieve(String item, ValueListItemRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/value_list_items/%s", ApiResource.urlEncodeId(item));
        return (ValueListItem)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)ValueListItem.class), options, ApiMode.V1);
    }

    public ValueListItem delete(String item) throws StripeException {
        return this.delete(item, null);
    }

    public ValueListItem delete(String item, RequestOptions options) throws StripeException {
        String path = String.format("/v1/radar/value_list_items/%s", ApiResource.urlEncodeId(item));
        return (ValueListItem)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, (Type)((Object)ValueListItem.class), options, ApiMode.V1);
    }
}

