/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.WebhookEndpoint;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.WebhookEndpointCreateParams;
import com.stripe.param.WebhookEndpointListParams;
import com.stripe.param.WebhookEndpointRetrieveParams;
import com.stripe.param.WebhookEndpointUpdateParams;
import java.lang.reflect.Type;

public final class WebhookEndpointService
extends ApiService {
    public WebhookEndpointService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<WebhookEndpoint> list(WebhookEndpointListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<WebhookEndpoint> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<WebhookEndpoint> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<WebhookEndpoint> list(WebhookEndpointListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/webhook_endpoints";
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<WebhookEndpoint>>(){}.getType(), options, ApiMode.V1);
    }

    public WebhookEndpoint create(WebhookEndpointCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public WebhookEndpoint create(WebhookEndpointCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/webhook_endpoints";
        return (WebhookEndpoint)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)WebhookEndpoint.class), options, ApiMode.V1);
    }

    public WebhookEndpoint retrieve(String webhookEndpoint, WebhookEndpointRetrieveParams params) throws StripeException {
        return this.retrieve(webhookEndpoint, params, null);
    }

    public WebhookEndpoint retrieve(String webhookEndpoint, RequestOptions options) throws StripeException {
        return this.retrieve(webhookEndpoint, null, options);
    }

    public WebhookEndpoint retrieve(String webhookEndpoint) throws StripeException {
        return this.retrieve(webhookEndpoint, null, null);
    }

    public WebhookEndpoint retrieve(String webhookEndpoint, WebhookEndpointRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(webhookEndpoint));
        return (WebhookEndpoint)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)WebhookEndpoint.class), options, ApiMode.V1);
    }

    public WebhookEndpoint update(String webhookEndpoint, WebhookEndpointUpdateParams params) throws StripeException {
        return this.update(webhookEndpoint, params, null);
    }

    public WebhookEndpoint update(String webhookEndpoint, RequestOptions options) throws StripeException {
        return this.update(webhookEndpoint, null, options);
    }

    public WebhookEndpoint update(String webhookEndpoint) throws StripeException {
        return this.update(webhookEndpoint, null, null);
    }

    public WebhookEndpoint update(String webhookEndpoint, WebhookEndpointUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(webhookEndpoint));
        return (WebhookEndpoint)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)WebhookEndpoint.class), options, ApiMode.V1);
    }

    public WebhookEndpoint delete(String webhookEndpoint) throws StripeException {
        return this.delete(webhookEndpoint, null);
    }

    public WebhookEndpoint delete(String webhookEndpoint, RequestOptions options) throws StripeException {
        String path = String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(webhookEndpoint));
        return (WebhookEndpoint)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, (Type)((Object)WebhookEndpoint.class), options, ApiMode.V1);
    }
}

