/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.Person;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PersonCreateParams;
import com.stripe.param.PersonListParams;
import com.stripe.param.PersonRetrieveParams;
import com.stripe.param.PersonUpdateParams;
import java.lang.reflect.Type;

public final class PersonService
extends ApiService {
    public PersonService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Person> list(String account, PersonListParams params) throws StripeException {
        return this.list(account, params, null);
    }

    public StripeCollection<Person> list(String account, RequestOptions options) throws StripeException {
        return this.list(account, null, options);
    }

    public StripeCollection<Person> list(String account) throws StripeException {
        return this.list(account, null, null);
    }

    public StripeCollection<Person> list(String account, PersonListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons", ApiResource.urlEncodeId(account));
        return (StripeCollection)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), new TypeToken<StripeCollection<Person>>(){}.getType(), options, ApiMode.V1);
    }

    public Person create(String account, PersonCreateParams params) throws StripeException {
        return this.create(account, params, null);
    }

    public Person create(String account, RequestOptions options) throws StripeException {
        return this.create(account, null, options);
    }

    public Person create(String account) throws StripeException {
        return this.create(account, null, null);
    }

    public Person create(String account, PersonCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons", ApiResource.urlEncodeId(account));
        return (Person)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Person.class), options, ApiMode.V1);
    }

    public Person retrieve(String account, String person, PersonRetrieveParams params) throws StripeException {
        return this.retrieve(account, person, params, null);
    }

    public Person retrieve(String account, String person, RequestOptions options) throws StripeException {
        return this.retrieve(account, person, null, options);
    }

    public Person retrieve(String account, String person) throws StripeException {
        return this.retrieve(account, person, null, null);
    }

    public Person retrieve(String account, String person, PersonRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(account), ApiResource.urlEncodeId(person));
        return (Person)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Person.class), options, ApiMode.V1);
    }

    public Person update(String account, String person, PersonUpdateParams params) throws StripeException {
        return this.update(account, person, params, null);
    }

    public Person update(String account, String person, RequestOptions options) throws StripeException {
        return this.update(account, person, null, options);
    }

    public Person update(String account, String person) throws StripeException {
        return this.update(account, person, null, null);
    }

    public Person update(String account, String person, PersonUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(account), ApiResource.urlEncodeId(person));
        return (Person)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Person.class), options, ApiMode.V1);
    }

    public Person delete(String account, String person) throws StripeException {
        return this.delete(account, person, null);
    }

    public Person delete(String account, String person, RequestOptions options) throws StripeException {
        String path = String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(account), ApiResource.urlEncodeId(person));
        return (Person)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, (Type)((Object)Person.class), options, ApiMode.V1);
    }
}

