/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.financialconnections;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.financialconnections.AccountCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.financialconnections.SessionCreateParams;
import com.stripe.param.financialconnections.SessionRetrieveParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Session
extends ApiResource
implements HasId {
    @SerializedName(value="account_holder")
    AccountHolder accountHolder;
    @SerializedName(value="accounts")
    AccountCollection accounts;
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="filters")
    Filters filters;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="permissions")
    List<String> permissions;
    @SerializedName(value="return_url")
    String returnUrl;

    public static Session create(Map<String, Object> params) throws StripeException {
        return Session.create(params, (RequestOptions)null);
    }

    public static Session create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/financial_connections/sessions";
        return (Session)Session.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Session.class), options, ApiMode.V1);
    }

    public static Session create(SessionCreateParams params) throws StripeException {
        return Session.create(params, (RequestOptions)null);
    }

    public static Session create(SessionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/financial_connections/sessions";
        ApiResource.checkNullTypedParams(path, params);
        return (Session)Session.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Session.class), options, ApiMode.V1);
    }

    public static Session retrieve(String session) throws StripeException {
        return Session.retrieve(session, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Session retrieve(String session, RequestOptions options) throws StripeException {
        return Session.retrieve(session, (Map<String, Object>)null, options);
    }

    public static Session retrieve(String session, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/sessions/%s", ApiResource.urlEncodeId(session));
        return (Session)Session.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)Session.class), options, ApiMode.V1);
    }

    public static Session retrieve(String session, SessionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/financial_connections/sessions/%s", ApiResource.urlEncodeId(session));
        ApiResource.checkNullTypedParams(path, params);
        return (Session)Session.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Session.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.accountHolder, responseGetter);
        this.trySetResponseGetter(this.accounts, responseGetter);
        this.trySetResponseGetter(this.filters, responseGetter);
    }

    @Generated
    public AccountHolder getAccountHolder() {
        return this.accountHolder;
    }

    @Generated
    public AccountCollection getAccounts() {
        return this.accounts;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public Filters getFilters() {
        return this.filters;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<String> getPermissions() {
        return this.permissions;
    }

    @Generated
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Generated
    public void setAccountHolder(AccountHolder accountHolder) {
        this.accountHolder = accountHolder;
    }

    @Generated
    public void setAccounts(AccountCollection accounts) {
        this.accounts = accounts;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setFilters(Filters filters) {
        this.filters = filters;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    @Generated
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Session)) {
            return false;
        }
        Session other = (Session)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AccountHolder this$accountHolder = this.getAccountHolder();
        AccountHolder other$accountHolder = other.getAccountHolder();
        if (this$accountHolder == null ? other$accountHolder != null : !((Object)this$accountHolder).equals(other$accountHolder)) {
            return false;
        }
        AccountCollection this$accounts = this.getAccounts();
        AccountCollection other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        Filters this$filters = this.getFilters();
        Filters other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<String> this$permissions = this.getPermissions();
        List<String> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        String this$returnUrl = this.getReturnUrl();
        String other$returnUrl = other.getReturnUrl();
        return !(this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Session;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AccountHolder $accountHolder = this.getAccountHolder();
        result = result * 59 + ($accountHolder == null ? 43 : ((Object)$accountHolder).hashCode());
        AccountCollection $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        Filters $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<String> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        String $returnUrl = this.getReturnUrl();
        result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class AccountHolder
    extends StripeObject {
        @SerializedName(value="account")
        ExpandableField<Account> account;
        @SerializedName(value="customer")
        ExpandableField<Customer> customer;
        @SerializedName(value="type")
        String type;

        public String getAccount() {
            return this.account != null ? this.account.getId() : null;
        }

        public void setAccount(String id) {
            this.account = ApiResource.setExpandableFieldId(id, this.account);
        }

        public Account getAccountObject() {
            return this.account != null ? this.account.getExpanded() : null;
        }

        public void setAccountObject(Account expandableObject) {
            this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        public String getCustomer() {
            return this.customer != null ? this.customer.getId() : null;
        }

        public void setCustomer(String id) {
            this.customer = ApiResource.setExpandableFieldId(id, this.customer);
        }

        public Customer getCustomerObject() {
            return this.customer != null ? this.customer.getExpanded() : null;
        }

        public void setCustomerObject(Customer expandableObject) {
            this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AccountHolder)) {
                return false;
            }
            AccountHolder other = (AccountHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$customer = this.getCustomer();
            String other$customer = other.getCustomer();
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AccountHolder;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $customer = this.getCustomer();
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class Filters
    extends StripeObject {
        @SerializedName(value="countries")
        List<String> countries;

        @Generated
        public List<String> getCountries() {
            return this.countries;
        }

        @Generated
        public void setCountries(List<String> countries) {
            this.countries = countries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Filters)) {
                return false;
            }
            Filters other = (Filters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$countries = this.getCountries();
            List<String> other$countries = other.getCountries();
            return !(this$countries == null ? other$countries != null : !((Object)this$countries).equals(other$countries));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Filters;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $countries = this.getCountries();
            result = result * 59 + ($countries == null ? 43 : ((Object)$countries).hashCode());
            return result;
        }
    }
}

