/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.billingportal;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Application;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.billingportal.ConfigurationCollection;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billingportal.ConfigurationCreateParams;
import com.stripe.param.billingportal.ConfigurationListParams;
import com.stripe.param.billingportal.ConfigurationRetrieveParams;
import com.stripe.param.billingportal.ConfigurationUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Configuration
extends ApiResource
implements HasId,
MetadataStore<Configuration> {
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="business_profile")
    BusinessProfile businessProfile;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="default_return_url")
    String defaultReturnUrl;
    @SerializedName(value="features")
    Features features;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="is_default")
    Boolean isDefault;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="login_page")
    LoginPage loginPage;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="updated")
    Long updated;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public static Configuration create(Map<String, Object> params) throws StripeException {
        return Configuration.create(params, (RequestOptions)null);
    }

    public static Configuration create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing_portal/configurations";
        return (Configuration)Configuration.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Configuration.class), options, ApiMode.V1);
    }

    public static Configuration create(ConfigurationCreateParams params) throws StripeException {
        return Configuration.create(params, (RequestOptions)null);
    }

    public static Configuration create(ConfigurationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing_portal/configurations";
        ApiResource.checkNullTypedParams(path, params);
        return (Configuration)Configuration.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Configuration.class), options, ApiMode.V1);
    }

    public static ConfigurationCollection list(Map<String, Object> params) throws StripeException {
        return Configuration.list(params, (RequestOptions)null);
    }

    public static ConfigurationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing_portal/configurations";
        return (ConfigurationCollection)Configuration.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)ConfigurationCollection.class), options, ApiMode.V1);
    }

    public static ConfigurationCollection list(ConfigurationListParams params) throws StripeException {
        return Configuration.list(params, (RequestOptions)null);
    }

    public static ConfigurationCollection list(ConfigurationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing_portal/configurations";
        ApiResource.checkNullTypedParams(path, params);
        return (ConfigurationCollection)Configuration.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)ConfigurationCollection.class), options, ApiMode.V1);
    }

    public static Configuration retrieve(String configuration) throws StripeException {
        return Configuration.retrieve(configuration, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Configuration retrieve(String configuration, RequestOptions options) throws StripeException {
        return Configuration.retrieve(configuration, (Map<String, Object>)null, options);
    }

    public static Configuration retrieve(String configuration, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing_portal/configurations/%s", ApiResource.urlEncodeId(configuration));
        return (Configuration)Configuration.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, (Type)((Object)Configuration.class), options, ApiMode.V1);
    }

    public static Configuration retrieve(String configuration, ConfigurationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing_portal/configurations/%s", ApiResource.urlEncodeId(configuration));
        ApiResource.checkNullTypedParams(path, params);
        return (Configuration)Configuration.getGlobalResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Configuration.class), options, ApiMode.V1);
    }

    public Configuration update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Configuration update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing_portal/configurations/%s", ApiResource.urlEncodeId(this.getId()));
        return (Configuration)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)Configuration.class), options, ApiMode.V1);
    }

    public Configuration update(ConfigurationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Configuration update(ConfigurationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing_portal/configurations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (Configuration)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)Configuration.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.application, responseGetter);
        this.trySetResponseGetter(this.businessProfile, responseGetter);
        this.trySetResponseGetter(this.features, responseGetter);
        this.trySetResponseGetter(this.loginPage, responseGetter);
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public BusinessProfile getBusinessProfile() {
        return this.businessProfile;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getDefaultReturnUrl() {
        return this.defaultReturnUrl;
    }

    @Generated
    public Features getFeatures() {
        return this.features;
    }

    @Generated
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public LoginPage getLoginPage() {
        return this.loginPage;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getUpdated() {
        return this.updated;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setBusinessProfile(BusinessProfile businessProfile) {
        this.businessProfile = businessProfile;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDefaultReturnUrl(String defaultReturnUrl) {
        this.defaultReturnUrl = defaultReturnUrl;
    }

    @Generated
    public void setFeatures(Features features) {
        this.features = features;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setLoginPage(LoginPage loginPage) {
        this.loginPage = loginPage;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$isDefault = this.getIsDefault();
        Boolean other$isDefault = other.getIsDefault();
        if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$updated = this.getUpdated();
        Long other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        BusinessProfile this$businessProfile = this.getBusinessProfile();
        BusinessProfile other$businessProfile = other.getBusinessProfile();
        if (this$businessProfile == null ? other$businessProfile != null : !((Object)this$businessProfile).equals(other$businessProfile)) {
            return false;
        }
        String this$defaultReturnUrl = this.getDefaultReturnUrl();
        String other$defaultReturnUrl = other.getDefaultReturnUrl();
        if (this$defaultReturnUrl == null ? other$defaultReturnUrl != null : !this$defaultReturnUrl.equals(other$defaultReturnUrl)) {
            return false;
        }
        Features this$features = this.getFeatures();
        Features other$features = other.getFeatures();
        if (this$features == null ? other$features != null : !((Object)this$features).equals(other$features)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LoginPage this$loginPage = this.getLoginPage();
        LoginPage other$loginPage = other.getLoginPage();
        if (this$loginPage == null ? other$loginPage != null : !((Object)this$loginPage).equals(other$loginPage)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        BusinessProfile $businessProfile = this.getBusinessProfile();
        result = result * 59 + ($businessProfile == null ? 43 : ((Object)$businessProfile).hashCode());
        String $defaultReturnUrl = this.getDefaultReturnUrl();
        result = result * 59 + ($defaultReturnUrl == null ? 43 : $defaultReturnUrl.hashCode());
        Features $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LoginPage $loginPage = this.getLoginPage();
        result = result * 59 + ($loginPage == null ? 43 : ((Object)$loginPage).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class BusinessProfile
    extends StripeObject {
        @SerializedName(value="headline")
        String headline;
        @SerializedName(value="privacy_policy_url")
        String privacyPolicyUrl;
        @SerializedName(value="terms_of_service_url")
        String termsOfServiceUrl;

        @Generated
        public String getHeadline() {
            return this.headline;
        }

        @Generated
        public String getPrivacyPolicyUrl() {
            return this.privacyPolicyUrl;
        }

        @Generated
        public String getTermsOfServiceUrl() {
            return this.termsOfServiceUrl;
        }

        @Generated
        public void setHeadline(String headline) {
            this.headline = headline;
        }

        @Generated
        public void setPrivacyPolicyUrl(String privacyPolicyUrl) {
            this.privacyPolicyUrl = privacyPolicyUrl;
        }

        @Generated
        public void setTermsOfServiceUrl(String termsOfServiceUrl) {
            this.termsOfServiceUrl = termsOfServiceUrl;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BusinessProfile)) {
                return false;
            }
            BusinessProfile other = (BusinessProfile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$headline = this.getHeadline();
            String other$headline = other.getHeadline();
            if (this$headline == null ? other$headline != null : !this$headline.equals(other$headline)) {
                return false;
            }
            String this$privacyPolicyUrl = this.getPrivacyPolicyUrl();
            String other$privacyPolicyUrl = other.getPrivacyPolicyUrl();
            if (this$privacyPolicyUrl == null ? other$privacyPolicyUrl != null : !this$privacyPolicyUrl.equals(other$privacyPolicyUrl)) {
                return false;
            }
            String this$termsOfServiceUrl = this.getTermsOfServiceUrl();
            String other$termsOfServiceUrl = other.getTermsOfServiceUrl();
            return !(this$termsOfServiceUrl == null ? other$termsOfServiceUrl != null : !this$termsOfServiceUrl.equals(other$termsOfServiceUrl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BusinessProfile;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $headline = this.getHeadline();
            result = result * 59 + ($headline == null ? 43 : $headline.hashCode());
            String $privacyPolicyUrl = this.getPrivacyPolicyUrl();
            result = result * 59 + ($privacyPolicyUrl == null ? 43 : $privacyPolicyUrl.hashCode());
            String $termsOfServiceUrl = this.getTermsOfServiceUrl();
            result = result * 59 + ($termsOfServiceUrl == null ? 43 : $termsOfServiceUrl.hashCode());
            return result;
        }
    }

    public static class Features
    extends StripeObject {
        @SerializedName(value="customer_update")
        CustomerUpdate customerUpdate;
        @SerializedName(value="invoice_history")
        InvoiceHistory invoiceHistory;
        @SerializedName(value="payment_method_update")
        PaymentMethodUpdate paymentMethodUpdate;
        @SerializedName(value="subscription_cancel")
        SubscriptionCancel subscriptionCancel;
        @SerializedName(value="subscription_pause")
        SubscriptionPause subscriptionPause;
        @SerializedName(value="subscription_update")
        SubscriptionUpdate subscriptionUpdate;

        @Generated
        public CustomerUpdate getCustomerUpdate() {
            return this.customerUpdate;
        }

        @Generated
        public InvoiceHistory getInvoiceHistory() {
            return this.invoiceHistory;
        }

        @Generated
        public PaymentMethodUpdate getPaymentMethodUpdate() {
            return this.paymentMethodUpdate;
        }

        @Generated
        public SubscriptionCancel getSubscriptionCancel() {
            return this.subscriptionCancel;
        }

        @Generated
        public SubscriptionPause getSubscriptionPause() {
            return this.subscriptionPause;
        }

        @Generated
        public SubscriptionUpdate getSubscriptionUpdate() {
            return this.subscriptionUpdate;
        }

        @Generated
        public void setCustomerUpdate(CustomerUpdate customerUpdate) {
            this.customerUpdate = customerUpdate;
        }

        @Generated
        public void setInvoiceHistory(InvoiceHistory invoiceHistory) {
            this.invoiceHistory = invoiceHistory;
        }

        @Generated
        public void setPaymentMethodUpdate(PaymentMethodUpdate paymentMethodUpdate) {
            this.paymentMethodUpdate = paymentMethodUpdate;
        }

        @Generated
        public void setSubscriptionCancel(SubscriptionCancel subscriptionCancel) {
            this.subscriptionCancel = subscriptionCancel;
        }

        @Generated
        public void setSubscriptionPause(SubscriptionPause subscriptionPause) {
            this.subscriptionPause = subscriptionPause;
        }

        @Generated
        public void setSubscriptionUpdate(SubscriptionUpdate subscriptionUpdate) {
            this.subscriptionUpdate = subscriptionUpdate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Features)) {
                return false;
            }
            Features other = (Features)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CustomerUpdate this$customerUpdate = this.getCustomerUpdate();
            CustomerUpdate other$customerUpdate = other.getCustomerUpdate();
            if (this$customerUpdate == null ? other$customerUpdate != null : !((Object)this$customerUpdate).equals(other$customerUpdate)) {
                return false;
            }
            InvoiceHistory this$invoiceHistory = this.getInvoiceHistory();
            InvoiceHistory other$invoiceHistory = other.getInvoiceHistory();
            if (this$invoiceHistory == null ? other$invoiceHistory != null : !((Object)this$invoiceHistory).equals(other$invoiceHistory)) {
                return false;
            }
            PaymentMethodUpdate this$paymentMethodUpdate = this.getPaymentMethodUpdate();
            PaymentMethodUpdate other$paymentMethodUpdate = other.getPaymentMethodUpdate();
            if (this$paymentMethodUpdate == null ? other$paymentMethodUpdate != null : !((Object)this$paymentMethodUpdate).equals(other$paymentMethodUpdate)) {
                return false;
            }
            SubscriptionCancel this$subscriptionCancel = this.getSubscriptionCancel();
            SubscriptionCancel other$subscriptionCancel = other.getSubscriptionCancel();
            if (this$subscriptionCancel == null ? other$subscriptionCancel != null : !((Object)this$subscriptionCancel).equals(other$subscriptionCancel)) {
                return false;
            }
            SubscriptionPause this$subscriptionPause = this.getSubscriptionPause();
            SubscriptionPause other$subscriptionPause = other.getSubscriptionPause();
            if (this$subscriptionPause == null ? other$subscriptionPause != null : !((Object)this$subscriptionPause).equals(other$subscriptionPause)) {
                return false;
            }
            SubscriptionUpdate this$subscriptionUpdate = this.getSubscriptionUpdate();
            SubscriptionUpdate other$subscriptionUpdate = other.getSubscriptionUpdate();
            return !(this$subscriptionUpdate == null ? other$subscriptionUpdate != null : !((Object)this$subscriptionUpdate).equals(other$subscriptionUpdate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Features;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CustomerUpdate $customerUpdate = this.getCustomerUpdate();
            result = result * 59 + ($customerUpdate == null ? 43 : ((Object)$customerUpdate).hashCode());
            InvoiceHistory $invoiceHistory = this.getInvoiceHistory();
            result = result * 59 + ($invoiceHistory == null ? 43 : ((Object)$invoiceHistory).hashCode());
            PaymentMethodUpdate $paymentMethodUpdate = this.getPaymentMethodUpdate();
            result = result * 59 + ($paymentMethodUpdate == null ? 43 : ((Object)$paymentMethodUpdate).hashCode());
            SubscriptionCancel $subscriptionCancel = this.getSubscriptionCancel();
            result = result * 59 + ($subscriptionCancel == null ? 43 : ((Object)$subscriptionCancel).hashCode());
            SubscriptionPause $subscriptionPause = this.getSubscriptionPause();
            result = result * 59 + ($subscriptionPause == null ? 43 : ((Object)$subscriptionPause).hashCode());
            SubscriptionUpdate $subscriptionUpdate = this.getSubscriptionUpdate();
            result = result * 59 + ($subscriptionUpdate == null ? 43 : ((Object)$subscriptionUpdate).hashCode());
            return result;
        }

        public static class CustomerUpdate
        extends StripeObject {
            @SerializedName(value="allowed_updates")
            List<String> allowedUpdates;
            @SerializedName(value="enabled")
            Boolean enabled;

            @Generated
            public List<String> getAllowedUpdates() {
                return this.allowedUpdates;
            }

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public void setAllowedUpdates(List<String> allowedUpdates) {
                this.allowedUpdates = allowedUpdates;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CustomerUpdate)) {
                    return false;
                }
                CustomerUpdate other = (CustomerUpdate)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                List<String> this$allowedUpdates = this.getAllowedUpdates();
                List<String> other$allowedUpdates = other.getAllowedUpdates();
                return !(this$allowedUpdates == null ? other$allowedUpdates != null : !((Object)this$allowedUpdates).equals(other$allowedUpdates));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CustomerUpdate;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                List<String> $allowedUpdates = this.getAllowedUpdates();
                result = result * 59 + ($allowedUpdates == null ? 43 : ((Object)$allowedUpdates).hashCode());
                return result;
            }
        }

        public static class InvoiceHistory
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InvoiceHistory)) {
                    return false;
                }
                InvoiceHistory other = (InvoiceHistory)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InvoiceHistory;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                return result;
            }
        }

        public static class PaymentMethodUpdate
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PaymentMethodUpdate)) {
                    return false;
                }
                PaymentMethodUpdate other = (PaymentMethodUpdate)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PaymentMethodUpdate;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                return result;
            }
        }

        public static class SubscriptionCancel
        extends StripeObject {
            @SerializedName(value="cancellation_reason")
            CancellationReason cancellationReason;
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="mode")
            String mode;
            @SerializedName(value="proration_behavior")
            String prorationBehavior;

            @Generated
            public CancellationReason getCancellationReason() {
                return this.cancellationReason;
            }

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public String getMode() {
                return this.mode;
            }

            @Generated
            public String getProrationBehavior() {
                return this.prorationBehavior;
            }

            @Generated
            public void setCancellationReason(CancellationReason cancellationReason) {
                this.cancellationReason = cancellationReason;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setMode(String mode) {
                this.mode = mode;
            }

            @Generated
            public void setProrationBehavior(String prorationBehavior) {
                this.prorationBehavior = prorationBehavior;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SubscriptionCancel)) {
                    return false;
                }
                SubscriptionCancel other = (SubscriptionCancel)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                CancellationReason this$cancellationReason = this.getCancellationReason();
                CancellationReason other$cancellationReason = other.getCancellationReason();
                if (this$cancellationReason == null ? other$cancellationReason != null : !((Object)this$cancellationReason).equals(other$cancellationReason)) {
                    return false;
                }
                String this$mode = this.getMode();
                String other$mode = other.getMode();
                if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
                    return false;
                }
                String this$prorationBehavior = this.getProrationBehavior();
                String other$prorationBehavior = other.getProrationBehavior();
                return !(this$prorationBehavior == null ? other$prorationBehavior != null : !this$prorationBehavior.equals(other$prorationBehavior));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SubscriptionCancel;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                CancellationReason $cancellationReason = this.getCancellationReason();
                result = result * 59 + ($cancellationReason == null ? 43 : ((Object)$cancellationReason).hashCode());
                String $mode = this.getMode();
                result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
                String $prorationBehavior = this.getProrationBehavior();
                result = result * 59 + ($prorationBehavior == null ? 43 : $prorationBehavior.hashCode());
                return result;
            }

            public static class CancellationReason
            extends StripeObject {
                @SerializedName(value="enabled")
                Boolean enabled;
                @SerializedName(value="options")
                List<String> options;

                @Generated
                public Boolean getEnabled() {
                    return this.enabled;
                }

                @Generated
                public List<String> getOptions() {
                    return this.options;
                }

                @Generated
                public void setEnabled(Boolean enabled) {
                    this.enabled = enabled;
                }

                @Generated
                public void setOptions(List<String> options) {
                    this.options = options;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CancellationReason)) {
                        return false;
                    }
                    CancellationReason other = (CancellationReason)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$enabled = this.getEnabled();
                    Boolean other$enabled = other.getEnabled();
                    if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                        return false;
                    }
                    List<String> this$options = this.getOptions();
                    List<String> other$options = other.getOptions();
                    return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof CancellationReason;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $enabled = this.getEnabled();
                    result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                    List<String> $options = this.getOptions();
                    result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
                    return result;
                }
            }
        }

        public static class SubscriptionPause
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SubscriptionPause)) {
                    return false;
                }
                SubscriptionPause other = (SubscriptionPause)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SubscriptionPause;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                return result;
            }
        }

        public static class SubscriptionUpdate
        extends StripeObject {
            @SerializedName(value="default_allowed_updates")
            List<String> defaultAllowedUpdates;
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="products")
            List<Product> products;
            @SerializedName(value="proration_behavior")
            String prorationBehavior;

            @Generated
            public List<String> getDefaultAllowedUpdates() {
                return this.defaultAllowedUpdates;
            }

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public List<Product> getProducts() {
                return this.products;
            }

            @Generated
            public String getProrationBehavior() {
                return this.prorationBehavior;
            }

            @Generated
            public void setDefaultAllowedUpdates(List<String> defaultAllowedUpdates) {
                this.defaultAllowedUpdates = defaultAllowedUpdates;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setProducts(List<Product> products) {
                this.products = products;
            }

            @Generated
            public void setProrationBehavior(String prorationBehavior) {
                this.prorationBehavior = prorationBehavior;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SubscriptionUpdate)) {
                    return false;
                }
                SubscriptionUpdate other = (SubscriptionUpdate)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                List<String> this$defaultAllowedUpdates = this.getDefaultAllowedUpdates();
                List<String> other$defaultAllowedUpdates = other.getDefaultAllowedUpdates();
                if (this$defaultAllowedUpdates == null ? other$defaultAllowedUpdates != null : !((Object)this$defaultAllowedUpdates).equals(other$defaultAllowedUpdates)) {
                    return false;
                }
                List<Product> this$products = this.getProducts();
                List<Product> other$products = other.getProducts();
                if (this$products == null ? other$products != null : !((Object)this$products).equals(other$products)) {
                    return false;
                }
                String this$prorationBehavior = this.getProrationBehavior();
                String other$prorationBehavior = other.getProrationBehavior();
                return !(this$prorationBehavior == null ? other$prorationBehavior != null : !this$prorationBehavior.equals(other$prorationBehavior));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SubscriptionUpdate;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                List<String> $defaultAllowedUpdates = this.getDefaultAllowedUpdates();
                result = result * 59 + ($defaultAllowedUpdates == null ? 43 : ((Object)$defaultAllowedUpdates).hashCode());
                List<Product> $products = this.getProducts();
                result = result * 59 + ($products == null ? 43 : ((Object)$products).hashCode());
                String $prorationBehavior = this.getProrationBehavior();
                result = result * 59 + ($prorationBehavior == null ? 43 : $prorationBehavior.hashCode());
                return result;
            }

            public static class Product
            extends StripeObject {
                @SerializedName(value="prices")
                List<String> prices;
                @SerializedName(value="product")
                String product;

                @Generated
                public List<String> getPrices() {
                    return this.prices;
                }

                @Generated
                public String getProduct() {
                    return this.product;
                }

                @Generated
                public void setPrices(List<String> prices) {
                    this.prices = prices;
                }

                @Generated
                public void setProduct(String product) {
                    this.product = product;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Product)) {
                        return false;
                    }
                    Product other = (Product)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<String> this$prices = this.getPrices();
                    List<String> other$prices = other.getPrices();
                    if (this$prices == null ? other$prices != null : !((Object)this$prices).equals(other$prices)) {
                        return false;
                    }
                    String this$product = this.getProduct();
                    String other$product = other.getProduct();
                    return !(this$product == null ? other$product != null : !this$product.equals(other$product));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Product;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<String> $prices = this.getPrices();
                    result = result * 59 + ($prices == null ? 43 : ((Object)$prices).hashCode());
                    String $product = this.getProduct();
                    result = result * 59 + ($product == null ? 43 : $product.hashCode());
                    return result;
                }
            }
        }
    }

    public static class LoginPage
    extends StripeObject {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="url")
        String url;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoginPage)) {
                return false;
            }
            LoginPage other = (LoginPage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LoginPage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }
    }
}

