/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.model.Refund;
import com.stripe.model.Transfer;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.TransferReversalUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class TransferReversal
extends ApiResource
implements MetadataStore<TransferReversal>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="destination_payment_refund")
    ExpandableField<Refund> destinationPaymentRefund;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="source_refund")
    ExpandableField<Refund> sourceRefund;
    @SerializedName(value="transfer")
    ExpandableField<Transfer> transfer;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getDestinationPaymentRefund() {
        return this.destinationPaymentRefund != null ? this.destinationPaymentRefund.getId() : null;
    }

    public void setDestinationPaymentRefund(String id) {
        this.destinationPaymentRefund = ApiResource.setExpandableFieldId(id, this.destinationPaymentRefund);
    }

    public Refund getDestinationPaymentRefundObject() {
        return this.destinationPaymentRefund != null ? this.destinationPaymentRefund.getExpanded() : null;
    }

    public void setDestinationPaymentRefundObject(Refund expandableObject) {
        this.destinationPaymentRefund = new ExpandableField<Refund>(expandableObject.getId(), expandableObject);
    }

    public String getSourceRefund() {
        return this.sourceRefund != null ? this.sourceRefund.getId() : null;
    }

    public void setSourceRefund(String id) {
        this.sourceRefund = ApiResource.setExpandableFieldId(id, this.sourceRefund);
    }

    public Refund getSourceRefundObject() {
        return this.sourceRefund != null ? this.sourceRefund.getExpanded() : null;
    }

    public void setSourceRefundObject(Refund expandableObject) {
        this.sourceRefund = new ExpandableField<Refund>(expandableObject.getId(), expandableObject);
    }

    public String getTransfer() {
        return this.transfer != null ? this.transfer.getId() : null;
    }

    public void setTransfer(String id) {
        this.transfer = ApiResource.setExpandableFieldId(id, this.transfer);
    }

    public Transfer getTransferObject() {
        return this.transfer != null ? this.transfer.getExpanded() : null;
    }

    public void setTransferObject(Transfer expandableObject) {
        this.transfer = new ExpandableField<Transfer>(expandableObject.getId(), expandableObject);
    }

    public TransferReversal update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public TransferReversal update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/transfers/%s/reversals/%s", ApiResource.urlEncodeId(this.getTransfer()), ApiResource.urlEncodeId(this.getId()));
        return (TransferReversal)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, (Type)((Object)TransferReversal.class), options, ApiMode.V1);
    }

    public TransferReversal update(TransferReversalUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public TransferReversal update(TransferReversalUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/transfers/%s/reversals/%s", ApiResource.urlEncodeId(this.getTransfer()), ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        return (TransferReversal)this.getResponseGetter().request(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), (Type)((Object)TransferReversal.class), options, ApiMode.V1);
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.balanceTransaction, responseGetter);
        this.trySetResponseGetter(this.destinationPaymentRefund, responseGetter);
        this.trySetResponseGetter(this.sourceRefund, responseGetter);
        this.trySetResponseGetter(this.transfer, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferReversal)) {
            return false;
        }
        TransferReversal other = (TransferReversal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$destinationPaymentRefund = this.getDestinationPaymentRefund();
        String other$destinationPaymentRefund = other.getDestinationPaymentRefund();
        if (this$destinationPaymentRefund == null ? other$destinationPaymentRefund != null : !this$destinationPaymentRefund.equals(other$destinationPaymentRefund)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$sourceRefund = this.getSourceRefund();
        String other$sourceRefund = other.getSourceRefund();
        if (this$sourceRefund == null ? other$sourceRefund != null : !this$sourceRefund.equals(other$sourceRefund)) {
            return false;
        }
        String this$transfer = this.getTransfer();
        String other$transfer = other.getTransfer();
        return !(this$transfer == null ? other$transfer != null : !this$transfer.equals(other$transfer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransferReversal;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $destinationPaymentRefund = this.getDestinationPaymentRefund();
        result = result * 59 + ($destinationPaymentRefund == null ? 43 : $destinationPaymentRefund.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $sourceRefund = this.getSourceRefund();
        result = result * 59 + ($sourceRefund == null ? 43 : $sourceRefund.hashCode());
        String $transfer = this.getTransfer();
        result = result * 59 + ($transfer == null ? 43 : $transfer.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

