/*
 * Decompiled with CFR 0.152.
 */
package com.streamxhub.streamx.common.util;

import com.streamxhub.streamx.common.util.Logger;
import java.io.File;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class SystemPropertyUtils$
implements Logger {
    public static SystemPropertyUtils$ MODULE$;
    private transient org.slf4j.Logger com$streamxhub$streamx$common$util$Logger$$_logger;
    private final String com$streamxhub$streamx$common$util$Logger$$prefix;

    static {
        new SystemPropertyUtils$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public org.slf4j.Logger com$streamxhub$streamx$common$util$Logger$$_logger() {
        return this.com$streamxhub$streamx$common$util$Logger$$_logger;
    }

    @Override
    public void com$streamxhub$streamx$common$util$Logger$$_logger_$eq(org.slf4j.Logger x$1) {
        this.com$streamxhub$streamx$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String com$streamxhub$streamx$common$util$Logger$$prefix() {
        return this.com$streamxhub$streamx$common$util$Logger$$prefix;
    }

    @Override
    public final void com$streamxhub$streamx$common$util$Logger$_setter_$com$streamxhub$streamx$common$util$Logger$$prefix_$eq(String x$1) {
        this.com$streamxhub$streamx$common$util$Logger$$prefix = x$1;
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String string) {
        String string2;
        Predef$.MODULE$.require(key != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamX] key must not be null.");
        String string3 = key;
        if (string3.isEmpty()) {
            throw new IllegalArgumentException("key must not be empty.");
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            SecurityManager securityManager = System.getSecurityManager();
            String string = securityManager == null ? System.getProperty(string3) : AccessController.doPrivileged(new PrivilegedAction<String>(string3){
                private final String x1$1;

                public String run() {
                    return System.getProperty(this.x1$1);
                }
                {
                    this.x1$1 = x1$1;
                }
            });
            return string;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String ok = (String)success.value();
            String string4 = ok;
            String string5 = string4 == null ? string : string4;
            string2 = string5;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().warn(new StringBuilder(71).append("Unable to retrieve a system property '").append(string3).append("'; default values will be used, ").append(e.getMessage()).append(".").toString());
            string2 = string;
        } else {
            throw new MatchError((Object)try_);
        }
        String string6 = string2;
        return string6;
    }

    public boolean getBoolean(String key, boolean bl) {
        boolean bl2;
        String value = this.get(key);
        String string = value;
        if (string == null) {
            bl2 = bl;
        } else {
            boolean bl3 = "true".equals(string) ? true : ("yes".equals(string) ? true : "1".equals(string));
            if (bl3) {
                bl2 = true;
            } else {
                String string2;
                boolean bl4 = "false".equals(string) ? true : ("no".equals(string) ? true : "0".equals(string));
                if (bl4) {
                    bl2 = false;
                } else if (string != null && (string2 = string).isEmpty()) {
                    bl2 = false;
                } else {
                    this.logger().warn(new StringBuilder(76).append("Unable to parse the boolean system property '").append(key).append("':").append(value).append(" - using the default value: ").append(bl).append(".").toString());
                    bl2 = bl;
                }
            }
        }
        return bl2;
    }

    public int getInt(String key, int n) {
        int n2;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(MODULE$.get(key))).toInt());
        if (try_ instanceof Success) {
            int ok;
            Success success = (Success)try_;
            n2 = ok = BoxesRunTime.unboxToInt((Object)success.value());
        } else if (try_ instanceof Failure) {
            n2 = n;
        } else {
            throw new MatchError((Object)try_);
        }
        return n2;
    }

    public long getLong(String key, long l) {
        long l2;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(MODULE$.get(key))).toLong());
        if (try_ instanceof Success) {
            long ok;
            Success success = (Success)try_;
            l2 = ok = BoxesRunTime.unboxToLong((Object)success.value());
        } else if (try_ instanceof Failure) {
            l2 = l;
        } else {
            throw new MatchError((Object)try_);
        }
        return l2;
    }

    public String set(String key, String value) {
        return (String)System.getProperties().setProperty(key, value);
    }

    public String getOrElseUpdate(String key, String string) {
        String string2;
        String string3 = this.get(key);
        if (string3 == null) {
            this.set(key, string);
            string2 = string;
        } else {
            string2 = string3;
        }
        return string2;
    }

    public void setAppHome(String key, Class<?> clazz) {
        block0: {
            if (this.get(key) != null) break block0;
            String jarOrClassPath = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
            File file = new File(jarOrClassPath);
            String appHome = jarOrClassPath.endsWith("jar") ? file.getParentFile().getParentFile().getPath() : file.getPath().replaceAll("classes/$", "");
            this.set(key, appHome);
        }
    }

    private SystemPropertyUtils$() {
        MODULE$ = this;
        Logger.$init$(this);
    }
}

